<?php
require_once APPPATH . 'third_party/vendor/autoload.php';

defined('BASEPATH') or exit('No direct script access allowed');

class Analyze extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('bot_model');
        $this->load->model('bhashini_model');

    }

    public function index()
    {


    }
        /**
     * This function is used to fraud check from any identity.
     * It should return an array with keys 'candidateId', 'resumeId', and 'screeningId'.
     */
    public function attire()
    {
        // This function is used to verify the identity of the user
        // It can be used to check if the user is authorized to access the bot
        $encData = $this->input->get('data');
        $data = $this->isValidData($encData);
        if(!empty($data)){
            $this->load->view('analyze/attire_check',$data);
        } 
    }

    public function mobileVerify()
    {
        // This function is used to verify the identity of the user
        // It can be used to check if the user is authorized to access the bot
        $encData = $this->input->get('data');
        $data = $this->isValidData($encData);
        if(!empty($data)){
            $this->load->view('analyze/mobile_verify',$data);
        } 
    }
    public function identityVerify()
    {
        // This function is used to verify the identity of the user
        // It can be used to check if the user is authorized to access the bot
        $encData = $this->input->get('data');
        $data = $this->isValidData($encData);
        if(!empty($data)){
            
             if ($this->input->method() === 'post') {
                $postData = $this->input->post();
                //pre($postData);die;
                // $commonId = $this->session->userdata('commonId');
                // $params = array(
                //     'screeningId' => $data['screeningId'],
                //     'candidateId' => $data['candidateId'],
                //     'resumeId' => $data['resumeId'],
                //     'ref' => 'SID' . $commonId,
                //     'created' => date('Y-m-d H:i:s'),
                //     'isConsent' => 1,
                //     'candidateLanguageId' => isset($postData['candidateLanguageId']) ? $postData['candidateLanguageId'] : 0
                // );
                // $botInterviewId = $this->db->insert('bot_interview', $params);
                //$this->redirectToPage('identityVerify');
        } else{
                $this->load->view('analyze/identity_verify',$data);

        }
    }
}
    /**
     * This function is use for Proctoring.
     */
    public function proctor()
    {
        $jsonData = file_get_contents('php://input');
        if (!$jsonData) {
            return $this->output
                ->set_status_header(400)
                ->set_output(json_encode(['error' => 'No data received']));
        }

        $commonId = $this->session->userdata('commonId');
        if (!$commonId) {
            return $this->output
                ->set_status_header(400)
                ->set_output(json_encode(['error' => 'Common ID is required']));
        }

        // Decode and save the image
        $data = json_decode($jsonData, true);
        //pre($data);die;
        $keystrokeMap = isset($data['keystrokeMap']) ? $data['keystrokeMap'] : [];
        $focusLostCount = isset($data['focusLostCount']) ? $data['focusLostCount'] : 0;

        if (!isset($data['image'])) {
            return $this->output
                ->set_status_header(400)
                ->set_output(json_encode(['error' => 'Image is required']));
        }

        $imageData = $data['image']; // base64 encoded image
        $imageDir = FCPATH . 'assets/proctor/images/';
        if (!is_dir($imageDir)) {
            mkdir($imageDir, 0775, true);
        }

        $timestamp = date('Ymdhis');
        $imageName = $timestamp . $commonId . '.jpg';
        $imagePath = $imageDir . $imageName;
        //echo $imagePath . '/' . base64_decode($imageData);
        // Save the decoded image

        // Check image data
        if (empty($imageData)) {
            return $this->output->set_status_header(400)->set_output(json_encode(['error' => 'Image data is empty']));
        }

        // Strip header if needed
        if (strpos($imageData, 'base64,') !== false) {
            $imageData = explode('base64,', $imageData)[1];
        }
        $imageData = str_replace(' ', '+', $imageData);

        $write = file_put_contents($imagePath, base64_decode($imageData));

        if ($write === false) {
            return $this->output
                ->set_status_header(500)
                ->set_output(json_encode(['error' => " Failed to write file to $imagePath"]));
        }

        // $ch = curl_init('http://127.0.0.1:8000/api/proctor/analyze');
        $ch = curl_init(ENGINEURL . '/api/proctor/analyze');

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        $response = curl_exec($ch);
        curl_close($ch);
        //pre($response);die;
        // Save the response into a JSON file
        $logDir = FCPATH . 'assets/proctor/';
        if (!is_dir($logDir)) {
            mkdir($logDir, 0755, true);
        }
        $logFile = $logDir . basename($commonId) . '.json';

        $existing = file_exists($logFile) ? json_decode(file_get_contents($logFile), true) : [];
        $existing[] = [
            'timestamp' => date('Y-m-d H:i:s'),
            'keystrokeMap' => $keystrokeMap,
            'focusLostCount' => $focusLostCount,
            'response' => json_decode($response, true),
            'extractedImage' => $imageName
        ];

        $responseData = json_decode($response, true);
        if (!is_array($responseData)) {
            $responseData = ['error' => 'Invalid engine response'];
        }

        $responseData['extractedImage'] = $imageName;
        $responseData['focusLostCount'] = $focusLostCount;
        $responseData['suspicousKeys'] = $keystrokeMap;

        file_put_contents($logFile, json_encode($existing, JSON_PRETTY_PRINT));
        return $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($responseData));

    }

    public function verifyIdentity()
    {
        $jsonData = file_get_contents('php://input');

        if (!$jsonData) {
            return $this->output
                ->set_status_header(400)
                ->set_output(json_encode(['error' => 'No data received']));
        }

        try {
            $ch = curl_init(ENGINEURL . '/api/proctor/verify_identity');

            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
            curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);

            $response = curl_exec($ch);
            $curlError = curl_error($ch);
            curl_close($ch);

            if ($curlError) {
                return $this->output
                    ->set_status_header(500)
                    ->set_output(json_encode(['error' => 'Curl Error: ' . $curlError]));
            }

            $params = array(
                'identityStatus' => $response
            );
            $commonId = $this->session->userdata('commonId');
            $this->db->where('ref', 'SID' . $commonId);
            $this->db->update('bot_interview', $params);

            return $this->output
                ->set_content_type('application/json')
                ->set_output($response);

        } catch (Exception $e) {
            return $this->output
                ->set_status_header(500)
                ->set_output(json_encode(['error' => $e->getMessage()]));
        }
    }

    public function attireCheck()
    {
        $jsonData = file_get_contents('php://input');

        if (!$jsonData) {
            return $this->output
                ->set_status_header(400)
                ->set_output(json_encode(['error' => 'No data received']));
        }

        try {
            $ch = curl_init(ENGINEURL . '/api/proctor/attire_check');

            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
            curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);

            $response = curl_exec($ch);
            $curlError = curl_error($ch);
            curl_close($ch);

            if ($curlError) {
                return $this->output
                    ->set_status_header(500)
                    ->set_output(json_encode(['error' => 'Curl Error: ' . $curlError]));
            }


            $params = array(
                'attireStatus' => $response
            );

            $commonId = $this->session->userdata('commonId');
            $this->db->where('ref', 'SID' . $commonId);
            $this->db->update('bot_interview', $params);

            echo "success";
            return;

        } catch (Exception $e) {
            return $this->output
                ->set_status_header(500)
                ->set_output(json_encode(['error' => $e->getMessage()]));
        }
    }

    
public function voiceMatch()
    {
        // This function is used to verify the identity of the user
        // It can be used to check if the user is authorized to access the bot
        $encData = $this->input->get('data');
        $data = $this->isValidData($encData);
        if(!empty($data)){
            $this->load->view('analyze/voice_match',$data);
        } 
    }
    public function saveVoiceSample()
    {
        // Check for file and reference
        if (!isset($_FILES['audio']) || $_FILES['audio']['error'] !== UPLOAD_ERR_OK) {
            http_response_code(400);
            echo json_encode(['status' => 'error', 'message' => 'No file uploaded or upload error']);
            return;
        }

        // Get commonId from session
        $commonId = $this->session->userdata('commonId');

        if (!$commonId) {
            http_response_code(400);
            echo json_encode(['status' => 'error', 'message' => 'Common ID not found in session']);
            return;
        }
        // Clean and build filename
        $filename = 'reference' . $commonId . '.webm';

        // Ensure directory exists
        $uploadDir = FCPATH . 'assets/voice/';
        if (!is_dir($uploadDir)) {
            mkdir($uploadDir, 0755, true);
        }

        // Save file
        $uploadPath = $uploadDir . $filename;
        if (move_uploaded_file($_FILES['audio']['tmp_name'], $uploadPath)) {
            echo json_encode(['status' => 'success', 'filename' => $filename]);
        } else {
            http_response_code(500);
            echo json_encode(['status' => 'error', 'message' => 'Failed to move uploaded file']);
        }
    }


    public function checkVoiceQuality() {

        $commonId = $this->session->userdata('commonId');
        $audioFilePath = "assets/voice/reference.{$commonId}.wav";
        // Validate that the audio file exists
        if (!file_exists($audioFilePath)) {
            return ['error' => 'Audio file does not exist: ' . $audioFilePath];
        }
        
        // Initialize cURL
        $ch = curl_init(ENGINEURL . '/api/proctor/voice_quality');
        
        // Create CURLFile object for file upload
        $audioFile = new CURLFile($audioFilePath, 'audio/wav', 'audio.wav');
        
        // Prepare POST data with file
        $postData = [
            'audio' => $audioFile
        ];
        
        // Set cURL options
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: multipart/form-data'
        ]);
        
        // Execute the request
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $error = curl_error($ch);
        
        curl_close($ch);
        
        // Handle cURL errors
        if ($error) {
            return ['error' => 'cURL error: ' . $error];
        }
        
        // Parse JSON response
        $responseData = json_decode($response, true);

        // Add HTTP status code to response for debugging
        $responseData['http_status'] = $httpCode;
        
        return $responseData;
    }

}