<?php
require_once APPPATH . 'third_party/vendor/autoload.php';

defined('BASEPATH') or exit('No direct script access allowed');

class Api extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('bot_model');
        $this->load->model('bhashini_model');

    }

    public function index()
    {


    }
    public function saveInterviewVideo()
    {
        if (isset($_FILES['interview_video']) && $_FILES['interview_video']['error'] === UPLOAD_ERR_OK) {
            $uploadDir = FCPATH . 'assets/video/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0775, true); // Create the dir if it doesn't exist
            }

            $filename = $this->input->post('filename') ?? ('interview_' . time() . '.webm');
            $targetPath = $uploadDir . basename($filename);

            if (move_uploaded_file($_FILES['interview_video']['tmp_name'], $targetPath)) {
                echo json_encode(['status' => 'success', 'filename' => $filename]);
            } else {
                http_response_code(500);
                echo json_encode(['status' => 'error', 'message' => 'Could not move uploaded file.']);
            }
        } else {
            http_response_code(400);
            echo json_encode(['status' => 'error', 'message' => 'No video uploaded or upload error.']);
        }
    }

    public function saveAudioAnswer()
    {
        if ($_FILES['audioChunk']['error'] === UPLOAD_ERR_OK) {
            $filename = $_POST['filename'] ?? ('answer_' . time() . '.webm');
            $uploadPath = FCPATH . 'assets/audio/' . basename($filename);

            if (move_uploaded_file($_FILES['audioChunk']['tmp_name'], $uploadPath)) {
                echo json_encode(['status' => 'success', 'filename' => $filename]);
            } else {
                http_response_code(500);
                echo json_encode(['status' => 'error', 'message' => 'Failed to move uploaded file']);
            }
        } else {
            http_response_code(400);
            echo json_encode(['status' => 'error', 'message' => 'No file uploaded']);
        }
    }

    public function appendAudioAnswer()
    {
        // Check if the required data is present
        if (isset($_FILES['audio_chunk']) && $_FILES['audio_chunk']['error'] === UPLOAD_ERR_OK && isset($_POST['filename'])) {

            $uploadDir = FCPATH . 'assets/audio/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0775, true); // Create dir if it doesn't exist
            }

            // Use basename() to prevent directory traversal attacks
            $filename = basename($_POST['filename']);
            $targetPath = $uploadDir . $filename;

            // Get the content of the uploaded chunk
            $chunkData = file_get_contents($_FILES['audio_chunk']['tmp_name']);

            // Append the chunk data to the target file
            // The FILE_APPEND flag is the key to making this work
            if (file_put_contents($targetPath, $chunkData, FILE_APPEND | LOCK_EX) !== false) {
                echo json_encode(['status' => 'success', 'message' => 'Audio chunk appended successfully.']);
            } else {
                http_response_code(500);
                echo json_encode(['status' => 'error', 'message' => 'Failed to write Audio chunk to file.']);
            }
        } else {
            http_response_code(400);
            $error_message = 'No audio chunk or filename provided, or an upload error occurred.';
            if (isset($_FILES['audio_chunk']['error'])) {
                $error_message .= ' Error code: ' . $_FILES['audio_chunk']['error'];
            }
            echo json_encode(['status' => 'error', 'message' => $error_message]);
        }
    }

    public function getTranscript($commonId = null)
    {
        if (!$commonId) {
            show_error('Common ID is required.', 400);
            return;
        }

        $filename = 'chat' . basename($commonId) . '.json'; // Security: prevent path traversal
        $path = FCPATH . 'assets/chat/' . $filename;

        if (file_exists($path)) {
            $this->output
                ->set_content_type('application/json')
                ->set_output(file_get_contents($path));
        } else {
            // If the file doesn't exist yet, return an empty array.
            $this->output
                ->set_content_type('application/json')
                ->set_output(json_encode([]));
        }
    }

    public function appendInterviewChunk()
    {
        if (isset($_FILES['video_chunk']) && $_FILES['video_chunk']['error'] === UPLOAD_ERR_OK) {
            $uploadDir = FCPATH . 'assets/video/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0775, true);
            }

            $filename = $this->input->post('filename') ?? ('interview_' . time() . '.webm');
            $targetPath = $uploadDir . basename($filename);

            $chunkData = file_get_contents($_FILES['video_chunk']['tmp_name']);

            $result = file_put_contents($targetPath, $chunkData, FILE_APPEND);

            if ($result !== false) {
                echo json_encode(['status' => 'success', 'message' => 'Chunk appended']);
            } else {
                http_response_code(500);
                echo json_encode(['status' => 'error', 'message' => 'Failed to append chunk']);
            }
        } else {
            http_response_code(400);
            echo json_encode(['status' => 'error', 'message' => 'No chunk uploaded or upload error']);
        }
    }

    public function saveTranscript()
    {
        $data = json_decode(file_get_contents('php://input'), true);

        if (!isset($data['commonId']) || !isset($data['questionData'])) {
            show_error('Invalid request data', 400);
            return;
        }

        $commonId = basename($data['commonId']);
        $newData = $data['questionData'];
        $questionId = $newData['questionId'];

        $filename = 'chat' . $commonId . '.json';
        $path = FCPATH . 'assets/chat/' . $filename;

        if (!is_dir(FCPATH . 'assets/chat/')) {
            mkdir(FCPATH . 'assets/chat/', 0755, true);
        }

        // Use file locking to prevent race conditions
        $fp = fopen($path, 'c+');
        if (flock($fp, LOCK_EX)) {
            $contents = fread($fp, filesize($path) ?: 1);
            $transcript = json_decode($contents, true) ?: [];

            $found = false;
            foreach ($transcript as &$entry) {
                if ($entry['questionId'] == $questionId) {
                    // Merge new data into the existing entry
                    $entry = array_merge($entry, $newData);
                    $found = true;
                    break;
                }
            }
            unset($entry);

            if (!$found) {
                $transcript[] = $newData;
            }

            // Go back to the beginning of the file to overwrite
            ftruncate($fp, 0);
            rewind($fp);
            fwrite($fp, json_encode($transcript, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));

            flock($fp, LOCK_UN);
        }
        fclose($fp);

        echo json_encode(['status' => 'success']);
    }
    /**
     * Summary of updateTranscriptFile
     */
    function updateTranscriptFile($newData = array())
    {
        // $newData = Array
        // (
        //     'questionId' => 547,
        //     'user' => 'Yes, I can share about this.',
        //     'duration' => 5.2404930591583
        // );

        // echo $newdata['questionId'];
        $commonId = $this->session->userdata('commonId');
        echo $commonId;
        $jsonFilePath = FCPATH . 'assets/chat/chat' . $commonId . '.json';
        if (!file_exists($jsonFilePath)) {
            echo "JSON file not found.";
            return false;
        }

        // Read and decode JSON
        $jsonContent = file_get_contents($jsonFilePath);
        $data = json_decode($jsonContent, true);

        if (!is_array($data)) {
            echo "Invalid JSON structure.";
            return false;
        }
        //pre($newData);
        // Loop and update user field based on questionId
        foreach ($data as &$entry) {
            $qid = $entry['questionId'];
            // echo $newData['questionId'];die;
            if (isset($newData['questionId']) && $newData['questionId'] == $qid) {
                echo $newData['user'];
                $entry['user'] = $newData['user'];
            }
        }
        // Encode and save back
        $updatedJson = json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
        file_put_contents($jsonFilePath, $updatedJson);
        echo "User responses updated successfully.";
        return true;
    }
    /**
     * This function will call retell AI API to get the interview questions and answers.
     */
    public function onlyAIInterview($commonId = '')
    {
        header("Access-Control-Allow-Origin: *");
        header("Content-Type: application/json");
        try {
            $headers = [
                "Authorization: " . RETELL_API_KEY,
                "Content-Type: application/json"
            ];

            $data = json_encode([
                "agent_id" => AGENT_ID
            ]);

            $ch = curl_init(RETELL_URL . "/v2/create-web-call");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
            $response = curl_exec($ch);
            curl_close($ch);

            $res = json_decode($response, true);
            //echo $res['call_id'].'-'.$commonId;

            $this->db->where('ref', 'SID' . $commonId);
            $this->db->update('bot_interview', ['callId' => $res['call_id'] ?? null]);
            echo json_encode([
                "call_id" => $res['call_id'] ?? null,
                "access_token" => $res['access_token'] ?? null
            ]);

        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode(['error' => $e->getMessage()]);
        }
    }

    

    /**
     * Transcribe audio file
     */
    public function transcribeAudio()
    {
        try {
            if ($this->input->method() === 'post') {
                $maxRetries = 10;
                $retryDelay = 2; // in seconds
                $retry = 0;

                $rawData = trim(file_get_contents("php://input"));
                $data = json_decode($rawData, true);
                $fileName = $data['fileName'] ?? null;
                $question = $data['question'] ?? null;
                $commonId = $this->session->userdata('commonId');

                $arrQ = explode('_', $fileName);
                //extract questionId from the filename
                $questionId = (int) str_replace('q', '', $arrQ[0]);
                $screeningId = $arrQ[3];

                $getSettings = $this->bot_model->getSettings($screeningId);
                $langId = $this->bot_model->getLanguageId($getSettings);
                $language = $this->bot_model->getLanguages($langId);

                $filePath = FCPATH . 'assets/audio/' . $fileName;
                //echo $filePath;
                while (!file_exists($filePath) && $retry < $maxRetries) {
                    sleep($retryDelay);
                    $retry++;
                }

                // Check if the file exists
                if (!file_exists($filePath)) {
                    return $this->output->set_status_header(404)->set_output(json_encode(['error' => 'Audio file not found']));
                }
                flush();
                //This section wait till file is not completed ready before transcribes//
                $stable = $this->checkFileStability($filePath);
                if (!$stable) {
                    return $this->output->set_status_header(500)->set_output(json_encode(['error' => 'File size not stable after multiple checks']));
                }
                // section End//

                $start = microtime(true);

                if ($language['type'] == 'BHASHINI') {
                    //use ffmpeg here and convert audio into WAV and send to BHASHINI.
                    $inputFile = $filePath;
                    $outputFile = str_replace('webm', 'wav', $filePath);

                    // Detect OS if you need different paths
                    if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
                        $ffmpeg = "C:\\ffmpeg\\bin\\ffmpeg.exe"; // Windows full path
                    } else {
                        $ffmpeg = "ffmpeg"; // Linux (installed via apt/yum)
                    }

                    $cmd = $ffmpeg . " -i " . escapeshellarg($inputFile) . " -ar 44100 -ac 2 -f wav " . escapeshellarg($outputFile) . " 2>&1";

                    exec($cmd, $output, $return_var);

                    if ($return_var === 0) {
                        echo "✅ Conversion successful: $outputFile";
                        $transcript = $this->bhashini_model->callBhashiniSTT($outputFile, $language);
                    } else {
                        echo "❌ Error:\n" . implode("\n", $output);
                    }
                } else {
                    $arrData = $this->bot_model->callEngineSTT($filePath, $language);
                    $transcript = $arrData['transcript'];
                }

                // get duration of the request
                $end = microtime(true);
                $duration = $end - $start;

                // Check if the response is present and then add the questionId and duration to the json data
                if (isset($transcript)) {
                    // $transcript = $this->normalizeTranscription($language, $question, $transcript);
                    $updateData = [
                        'questionId' => $questionId,
                        'user' => $transcript,
                        'duration' => $duration
                    ];

                    // Update the transcript file with the new data
                    $this->updateTranscriptFile($updateData);
                } else {
                    $updateData = [
                        'questionId' => $questionId,
                        'user' => 'Response didn\'t understand.',
                        'duration' => 0
                    ];
                    $this->updateTranscriptFile($updateData);
                    //error_log("STT API Error Response: " . $body);
                }
            }
        } catch (RequestException $e) {
            echo "Guzzle Exception: " . $e->getMessage() . "\n";

            if ($e->hasResponse()) {
                echo "Error Response:\n" . $e->getResponse()->getBody();
            }
        } catch (Exception $e) {
            echo "General Exception: " . $e->getMessage() . "\n";
        }
    }

    /**
     * This function is use for normalization transcribe.
     */
    public function normalizeTranscription($language, $question, $transcript)
    {
        $this->db->select('prompt');
        $this->db->from('fill_prompts');
        $this->db->where('title', 'Convert_Transcript_to_Normalisation');
        $promptRow = $this->db->get()->row_array();
        //pre($promptRow); die;// Debugging line, remove in production
        $prompt = isset($promptRow['prompt']) ? $promptRow['prompt'] : '';
        $replace = array(
            '{{Language_Name}}' => $language['language'],
            '{{Question}}' => $question,
            '{{Transcript}}' => $transcript
        );
        $prompt = str_replace(array_keys($replace), array_values($replace), $prompt);        // Prepare data for insertion
        $data = $this->bot_model->callEngineLLM($prompt);
        if (isset($data['response'])) {
            $arrData = json_decode($data['response'], true); // true => associative array
            if (isset($arrData[0])) {
                $normalizedTranscript = $arrData[0]['Response_Transcript'] ?? '';
            }
        }
        // Implement normalization logic here
        return $normalizedTranscript;
    }

    /**
     * Check file stability
     */
    public function checkFileStability($filePath)
    {
        $maxAttempts = 10; // maximum attempts
        $attempt = 0;
        $stable = false;

        while (!$stable && $attempt < $maxAttempts) {
            $initialSize = filesize($filePath);
            sleep(1); // wait 1 second

            // Check again after waiting
            if (filesize($filePath) === $initialSize) {
                $stable = true; // file size stable
            }
            $attempt++;
        }

        return $stable;
    }
}