<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Bot extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('bot_model');
        $this->load->model('azureblob_model');
    }



    public function index()
    {
        $this->session->unset_userdata('commonId');
        $encData = $this->input->get('data');
        $data = $this->isValidData($encData);
        if (!empty($data)) {
            try {
                $timestampval = date('Ymd_His');
                $commonId = sprintf(
                    "_%s_%s_%s_%s",
                    $data['candidateId'],
                    $data['resumeId'],
                    $data['screeningId'],
                    $timestampval
                );
                $this->session->set_userdata('commonId', $commonId);
                // Pass decrypted data to view
                $data['getSettings'] = $this->bot_model->getSettings($data['screeningId']);
                $data['languages'] = $this->bot_model->getLanguages();
                $this->load->view('bot/index', $data);
            } catch (Exception $e) {
                log_message('error', 'Interview error: ' . $e->getMessage());
                $errorData = array(
                    'heading' => 'Interview error',
                    'message' => 'error: ' . $e->getMessage()
                );
                $this->load->view('errors/html/error_404', $errorData);
            }
        }
    }

    /**
     * This function is used to prepare the interview.
     */
    public function prepare()
    {
        //$path = str_replace('bot', 'engine', FCPATH);
        $encData = $this->input->get('data');
        $data = $this->isValidData($encData);
        $getSettings = $this->bot_model->getSettings($data['screeningId']);
        if($getSettings['interviewType'] == 'ONLY_AI'){
            redirect('bot/interviewAI?data=' . $this->input->get('data'));
        }else{
            $this->load->view('bot/prepare_interview', $data);
        }

    }

    /**
     * This function is used to validate the encrypted data.
     * It should return an array with keys 'candidateId', 'resumeId', and 'screeningId'.
    */
    public function ajaxPrepare()
    {
    $encData = $this->input->get('data');
    $data = $this->isValidData($encData);

    if (!empty($data)) {
        try {
            if ($this->input->method() === 'post') {
                $getSettings = $this->bot_model->getSettings($data['screeningId']);
                $questionsArray = $this->bot_model->getQuestionsToGenerate($getSettings);
                $total = count($questionsArray);

                // Phase 1: Insert all questions at once if not already inserted
                $langId = $this->bot_model->getLanguageId($getSettings);
                $this->db->from('questions_vernacular');
                $this->db->where('screeningId', $getSettings['screeningId']);
                $this->db->where('langId', $langId);
                $insertedCount = $this->db->count_all_results();

                if ($insertedCount < $total) {
                    $this->bot_model->generateAllQuestions($getSettings, $questionsArray);
                    $percent = intval((1 / ($total + $total)) * 100); // Just started
                    echo json_encode(['percent' => $percent]);
                    return;
                }
                // Phase 2: Generate audios for each question
                $questionsWithAudio = $this->bot_model->countQuestionsWithAudio($getSettings);
                //echo $questionsWithAudio. '/'. $total; die;// Debugging line, can be removed later
                //pre($questionsWithAudio);die;
                if ($questionsWithAudio < $total) {
                    $this->bot_model->generateAudioForQuestion($getSettings, $questionsWithAudio);
                    $percent = intval((($questionsWithAudio + 1 + $total) / ($total * 2)) * 100);
                    if ($questionsWithAudio + 1 >= $total) {
                        echo json_encode(['percent' => 100, 'redirect' => base_url('bot/interview?data=' . $this->input->get('data'))]);
                    } else {
                        echo json_encode(['percent' => $percent]);
                    }
                    return;
                }

                // All done
                echo json_encode(['percent' => 100, 'redirect' => base_url('bot/interview?data=' . $this->input->get('data'))]);
                return;
            }
        } catch (Exception $e) {
            echo json_encode(['error' => $e->getMessage()]);
            return;
        }
    }
    echo json_encode(['percent' => 0]);
}

    /**
     * This function is used to validate the encrypted data.
     * It should return an array with keys 'candidateId', 'resumeId', and 'screeningId'.
     * This function is use for system check like camera and speaker.
     */
    public function systemCheck()
    {
        // HARDCODE INSTEAD OF DECRYPTING
        $encData = $this->input->get('data');
        //echo $this->session->userdata('commonId');die;
        $data = $this->isValidData($encData);
        //pre($data);die;
        if (!empty($data)) {
            try {
                // First decrypt the data before trying to access array keys
                if ($this->input->method() === 'post') {
                    $isGivenInterview = $this->bot_model->isGivenInterview($data);
                    if (!empty($isGivenInterview)) {
                        // Candidate has already given the interview
                        redirect(base_url('bot/exit/3'));
                    } else {
                        $postData = $this->input->post();
                        //pre($postData);die;
                        $commonId = $this->session->userdata('commonId');
                        $params = array(
                            'screeningId' => $data['screeningId'],
                            'candidateId' => $data['candidateId'],
                            'resumeId' => $data['resumeId'],
                            'ref' => 'SID' . $commonId,
                            'created' => date('Y-m-d H:i:s'),
                            'isConsent' => 1,
                            'candidateLanguageId' => isset($postData['candidateLanguageId']) ? $postData['candidateLanguageId'] : 0
                        );
                        $botInterviewId = $this->db->insert('bot_interview', $params);
                       // $this->redirectToPage('systemCheck');
                    }
                }
            } catch (Exception $e) {
                log_message('error', 'System Check error: ' . $e->getMessage());
                $errorData = array(
                    'heading' => 'System Check error',
                    'message' => 'error: ' . $e->getMessage()
                );
                $this->load->view('errors/html/error_404', $errorData);
            }

            $this->load->view('bot/system_check', $data);
        }
        // PASS dummy data to view (optional)
    }

   public function redirectToPage($currentPage)
    {
        $encData = $this->input->get('data');
        $data = $this->isValidData($encData);
        if (!empty($data)) {
            $getSettings = $this->bot_model->getSettings($data['screeningId']);
            // echo $currentPage;
            // pre($getSettings);die;
            if ($getSettings['isFraudPage'] == 'on' && $currentPage == 'systemCheck') {
                redirect('analyze/identityVerify?data=' . $this->input->get('data'));
            } else if ($getSettings['isAttirePage'] == 'on' && ($currentPage == 'systemCheck'|| $currentPage == 'identityVerify')) {
                redirect('analyze/attire?data=' . $this->input->get('data'));
            }else if($getSettings['isVoiceMatchPage'] == 'on' && ($currentPage == 'attire'|| $currentPage == 'systemCheck'||$currentPage == 'identityVerify')){
                redirect('analyze/voiceMatch?data=' . $this->input->get('data'));
            }
            else{
                redirect('bot/prepare?data=' . $this->input->get('data'));
            }
        }
    }


    public function interview()
    {
        $encData = $this->input->get('data');
        $data = $this->isValidData($encData);
        //pre($data);die;
        if (!empty($data)) {
            try {
                $getSettings = $this->bot_model->getSettings($data['screeningId']);
                //pre($getSettings);die;
                $commonId = $this->session->userdata('commonId');
                $this->bot_model->updateInterviewStatus('IN_PROGRESS', $commonId);
                if ($getSettings['interviewType'] == 'AI_PRE_DEFINED' || $getSettings['interviewType'] == 'ONLY_CUSTOM') {
                    $getQuestions = $this->bot_model->getQuestions($getSettings);
                    //pre($getQuestions);die;
                    if (!empty($getQuestions)) {
                        $data['questions'] = $getQuestions;
                        $this->load->view('bot/interview', $data);
                    } else {
                        $errorData = array(
                            'heading' => 'No Questions Found',
                            'message' => 'There are no questions available for this interview.'
                        );
                        $this->load->view('errors/html/error_404', $errorData);
                    }
                }

            } catch (Exception $e) {
                log_message('error', 'Interview error: ' . $e->getMessage());
                $errorData = array(
                    'heading' => 'Interview error',
                    'message' => 'error: ' . $e->getMessage()
                );
                $this->load->view('errors/html/error_404', $errorData);
            }
        }
    }

    public function interviewAI()
    {
        $encData = $this->input->get('data');
        $data = $this->isValidData($encData);
        //pre($data);die;
        if (!empty($data)) {
            try {
                $getSettings = $this->bot_model->getSettings($data['screeningId']);
                //pre($getSettings);die;
                $commonId = $this->session->userdata('commonId');
                $this->bot_model->updateInterviewStatus('IN_PROGRESS', $commonId);
                if ($getSettings['interviewType'] == 'ONLY_AI') {
                    //pre($getQuestions);die;
                   $this->load->view('bot/interview_ai', $data);
                }

            } catch (Exception $e) {
                log_message('error', 'Interview error: ' . $e->getMessage());
                $errorData = array(
                    'heading' => 'Interview error',
                    'message' => 'error: ' . $e->getMessage()
                );
                $this->load->view('errors/html/error_404', $errorData);
            }
        }
    }
    public function exit($number)
    {
        $commonId = $this->session->userdata('commonId');
        $this->bot_model->updateInterviewStatus('END', $commonId);
        $this->session->unset_userdata('commonId');
        $this->load->view('bot/exit', ['number' => $number]);
    }
	
	public function voiceMatch()
    {
        // This function is used to verify the identity of the user
        // It can be used to check if the user is authorized to access the bot
        $encData = $this->input->get('data');
        $data = $this->isValidData($encData);
        if(!empty($data)){
            $this->load->view('bot/voice_match',$data);
        } 
    }
}