<?php

defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Report Controller
 * Handles interview report generation, scoring, and attire analysis
 */
class Report extends MY_Controller
{
    /**
     * Constructor - Loads required models
     */
    public function __construct()
    {
        parent::__construct();
        $this->load->model('report_model');
        $this->load->model('bot_model');
    }

    /**
     * extractQA Method is use to extract questions and answers from transcript of interview.
     */
    public function index($botInterviewId = '')
    {
        //This if block use when run cron as by cron $botInterviewId will be null.
        if($botInterviewId==''){
            $this->db->insert('tbl_cron_logs', array('cronName'=>'Bot-Report'));
            $this->db->order_by('id', 'DESC'); 
            $this->db->limit(1);
            $result = $this->db->get_where('bot_interview', array('isCron' => 0))->row_array();
            $botInterviewId = $result['id'];
            if($botInterviewId>0){
                $this->db->where('id',$botInterviewId);
                $this->db->update('bot_interview', array('isCron' => 1));
            }
           // pre($result);die;
        }
        if ($botInterviewId > 0) {
            //echo $botInterviewId;die;
           
            $arrData = $this->report_model->getDataFromBotInterview($botInterviewId);
            echo "Interview Type: " . $arrData['interviewType'];
            if ($arrData['interviewType'] == 'ONLY_AI') {
                $this->extractQA($botInterviewId);
            }
            $this->benchmark($botInterviewId);
            $this->questionWiseAnalysis($botInterviewId);
            $this->scoring($botInterviewId);
        }
    }

    public function extractQA($botInterviewId = '')
    {
        $arrData = $this->report_model->getDataFromBotInterview($botInterviewId);
        //pre($arrData);die;
        $arrBotRetellData = $this->getTranscriptFromRetell($arrData['callId'], $botInterviewId);
        if (!empty($arrBotRetellData)) {
            try {
                $prompt = $this->report_model->getPromptsByTitle('Generate_Report_Extract_Questions_Answers');

                $replace = array(
                    '{{App_Name}}' => 'Mira',
                    '{{Candidate_Name}}' => $arrData['candidateName'],
                    '{{Admin_Company_Name}}' => 'Adzip',
                    '{{transcript}}' => $arrBotRetellData['transcript'],
                    '{{questions}}' => $this->getQuestionsOfContextualInterview(),
                );

                $prompt = str_replace(array_keys($replace), array_values($replace), $prompt);        // Prepare data for insertion
                $generatedQA = $this->callEngineLLM($prompt);
                //pre($generatedQA);die;
                $arrBotRetellData['questionAnswers'] = $generatedQA; // true returns associative array
                pre($arrBotRetellData);


                $this->db->where('botInterviewId', $botInterviewId);
                $delete = $this->db->delete('bot_retell');

                $this->db->insert('bot_retell', $arrBotRetellData);
                echo $this->db->insert_id();
                echo "Transcript saved successfully.";

            } catch (\Exception $e) {
                echo "An exception occurred: " . $e->getMessage();
                return null;
            }
        }

    }


    /**
     * benchmark method - Processes interview data and generates benchmark answers for questions.
     * it checks admin wants own benchmark or AI should generate benchmark.
     * $botInterviewId The ID of the bot interview to process
     */
    public function benchmark($botInterviewId = '')
    {
        if ($botInterviewId > 0) {
            $arrData = $this->report_model->getDataFromBotInterview($botInterviewId);
            echo "Interview Type: " . $arrData['interviewType'];
            if ($arrData['interviewType'] == 'ONLY_AI') {
                $arrRetell = $this->report_model->getDataFromBotRetell($botInterviewId);
                $arrQA = json_decode($arrRetell['questionAnswers'], true);
            } else {
                $commonId = str_replace('SID', 'chat', $arrData['ref']);
                $jsonFilePath = FCPATH . 'assets/chat/' . $commonId . '.json';
                if (!file_exists($jsonFilePath)) {
                    echo "JSON file not found.";
                    return false;
                }
                echo $jsonFilePath;
                $jsonContent = file_get_contents($jsonFilePath);
                //pre($jsonContent);
                $arrQA = json_decode($jsonContent, true);
                if (!is_array($arrQA)) {
                    echo "Invalid JSON structure.";
                    return false;
                }
            }

            if (!empty($arrQA)) {
                if ($arrData['benchmarkType'] == 'AI') {
                    $this->benchmarkAI($arrData, $arrQA);
                } else {
                    $this->benchmarkUser($arrData, $arrQA);
                }

            }
        } else {
            show_404();
        }
    }

    /**
     * Calls the LLM engine API to process prompts
     * @param string $prompt The prompt to send to the LLM engine
     * @return string|null Returns the LLM response or null on error
     */
    public function callEngineLLM($prompt)
    {
        try {
            $client = new \GuzzleHttp\Client();

            $engineUrl = ENGINEURL . "/api/llm";
            $llmData = [
                'engine' => 'openai',
                'prompt' => $prompt, // this can be a string or heredoc or from file
            ];
            //echo $prompt;die;
            $response = $client->request('POST', $engineUrl, [
                'json' => $llmData
            ]);

            // Get body as string
            $body = $response->getBody()->getContents();

            // Decode JSON
            $data = json_decode($body, true); // true => associative array

            // Now access the 'response' field
            if (isset($data['response'])) {
                $translatedText = $data['response'];
                //echo $translatedText; die;// ✅ This will now show Hindi characters
                return $translatedText;
            } else {
                echo "Invalid response format.";
            }
        } catch (RequestException $e) {
            echo "Guzzle Exception: " . $e->getMessage() . "\n";

            if ($e->hasResponse()) {
                echo "Error Response:\n" . $e->getResponse()->getBody();
            }
        } catch (Exception $e) {
            echo "General Exception: " . $e->getMessage() . "\n";
        }
    }

    /**
     * Generates scoring analysis for an interview
     * Processes interview responses and generates detailed scoring metrics
     * @param string $botInterviewId The ID of the bot interview to score
     * @return void
     */
    public function scoring($botInterviewId = '')
    {
        $arrQues = [];
        if ($botInterviewId > 0) {
            $arrData = $this->report_model->getDataFromBotInterview($botInterviewId);
            //pre($arrData);die;
            $arrData['stricnessLevel'] = ($arrData['stricnessLevel'] == 'S') ? 'Strict' : 'Generous'; // Default to Medium if not set
            $arrQuestionwise = $this->report_model->getDataFromBotQuestionwise($botInterviewId);
            $skills = $this->report_model->formatSkills(unserialize($arrData['resumeSkillResponse']));
            foreach ($arrQuestionwise as $index => $question) {

                $arrQues[$index]['id'] = $question['id'];
                $arrQues[$index]['question'] = $question['question'];
                $arrQues[$index]['response'] = $question['response'];
                $arrQues[$index]['benchmark_response'] = $question['benchmark_response'] ?? '';
            }
            $arrQues = json_encode($arrQues, JSON_PRETTY_PRINT);
            // pre($arrQuestionwise);
            //pre($arrQues);
            //die;
            $prompt = $this->report_model->getPromptsByTitle('Generate_Report_Scoring');


            //pre(data: $data);die;

            $replace = array(
                '{{Candidate_Name}}' => $arrData['candidateName'],
                '{{Admin_Company_Name}}' => 'Adzip',
                '{{Domain}}' => $arrData['domains'],
                '{{Strictness_Level}}' => $arrData['stricnessLevel'],
                '{{Questions_Answers_With_Benchmark}}' => $arrQues,
                '{{Primary_Skill-1}}' => $skills['primary_skills'][0] ?? '',
                '{{Primary_Skill-2}}' => $skills['primary_skills'][1] ?? '',
                '{{Primary_Skill-3}}' => $skills['primary_skills'][2] ?? '',
                '{{Primary_Skill-4}}' => $skills['primary_skills'][3] ?? '',
                '{{Primary_Skill-5}}' => $skills['primary_skills'][4] ?? '',
                '{{Secondary_Skill-1}}' => $skills['secondary_skills'][0] ?? '',
                '{{Secondary_Skill-2}}' => $skills['secondary_skills'][1] ?? '',
                '{{Secondary_Skill-3}}' => $skills['secondary_skills'][2] ?? '',
                '{{Secondary_Skill-4}}' => $skills['secondary_skills'][3] ?? '',
                '{{Secondary_Skill-5}}' => $skills['secondary_skills'][4] ?? '',
            );

            $prompt = str_replace(array_keys($replace), array_values($replace), $prompt);        // Prepare data for insertion
           // echo $prompt;die;
            try {
                $generatedBenchmark = $this->callEngineLLM($prompt);
                //pre($generatedBenchmark);die;
                $arrBenchmark = json_decode($generatedBenchmark, true); // true returns associative array
                pre($arrBenchmark);
                $arrScoringData = [];
                if (!empty($arrBenchmark['Parameters'])) {
                    $parameters = $arrBenchmark['Parameters'];
                    foreach ($parameters as $index => $param) {
                        $arrScoringData[$index]['botInterviewId'] = $arrQuestionwise[0]['botInterviewId'];
                        $arrScoringData[$index]['candidateId'] = $arrQuestionwise[0]['candidateId'];
                        $arrScoringData[$index]['resumeId'] = $arrQuestionwise[0]['resumeId'];
                        $arrScoringData[$index]['screeningId'] = $arrQuestionwise[0]['screeningId'];
                        $arrScoringData[$index]['parameter'] = $param['Parameter_Name'];
                        $arrScoringData[$index]['score'] = $param['Score'];
                        $arrScoringData[$index]['feedback'] = $param['Feedback_Explanation'];
                        $arrScoringData[$index]['category'] = $param['Parameter_Category'];

                    }
                    pre($arrScoringData);
                    $this->report_model->insertScoringData($arrScoringData);

                }
                $arrFeedback = [];
                if (!empty($arrBenchmark)) {
                    $arrFeedback['botInterviewId'] = $arrData['id'];
                    $arrFeedback['candidateId'] = $arrData['candidateId'];
                    $arrFeedback['resumeId'] = $arrData['resumeId'];
                    $arrFeedback['screeningId'] = $arrData['screeningId'];
                    $arrFeedback['feedback'] = $arrBenchmark['Overall_Feedback'] ?? '';
                    $arrFeedback['Strength'] = $arrBenchmark['Strength'] ?? '';
                    $arrFeedback['weakness'] = $arrBenchmark['Weakness'] ?? '';
                    $this->db->where('botInterviewId', $arrData['id']);
                    $delete = $this->db->delete('bot_overall_feedback');
                    $this->db->insert('bot_overall_feedback', $arrFeedback);
                }

            } catch (\Exception $e) {
                echo "An exception occurred: " . $e->getMessage();
                return null;
            }

        } else {
            show_404();
        }
    }

    /**
     * Analyzes candidate's attire from interview recording
     * Processes image data and generates attire compliance report
     * @param string $botInterviewId The ID of the bot interview to analyze
     * @return bool|void Returns false on errors, void on success
     */
    public function attire($botInterviewId = '')
    {
        if ($botInterviewId > 0) {
            $arrData = $this->report_model->getDataFromBotInterview($botInterviewId);
            $jsonFilePath = str_replace('bot', 'attire', FCPATH) . 'assets/attire_result/' . $arrData['mobile'] . '.json';

            //echo $jsonFilePath;die;
            if (!file_exists($jsonFilePath)) {
                echo "JSON file not found.";
                return false;
            }

            $jsonContent = file_get_contents($jsonFilePath);
            $data['jsonContent'] = json_decode($jsonContent, true);
            if (!is_array($data)) {
                echo "Invalid JSON structure.";
                return false;
            }

            //pre($data);die;
            $imageFilePath = str_replace('bot', 'attire', FCPATH) . 'assets/images/' . $arrData['mobile'] . '.jpg';
            //$imageFilePath = str_replace('bot','attire_check',FCPATH) . 'assets/images/' . $arrData['mobile'] . '.jpg';

            $data['imgUrl'] = "https://attiretest.intrvuz.com/assets/images/" . $arrData['mobile'] . ".jpg";

           // $data['imgUrl'] = "http://localhost/new-grp/attire_check/assets/images/" . $arrData['mobile'] . ".jpg";
            $data['imageContent'] = $imageFilePath;

            $this->load->view('report/attire', $data);

            // Process and return the scoring data as needed
        } else {
            show_404();
        }
    }

    /**
     * Retrieves transcript from Retell AI service based on callId
     */
    public function getTranscriptFromRetell($callId, $botInterviewId = '')
    {

        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => RETELL_URL . "/v2/get-call/{$callId}",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => [
                "Authorization: " . RETELL_API_KEY
            ],
        ]);

        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            echo "cURL Error #:" . $err;
        } else {
            $arrTranscript = json_decode($response, TRUE);
            //pre($arrTranscript);die;
            $data['callId'] = $callId;
            $data['botInterviewId'] = $botInterviewId;
            $data['startTimestamp'] = $arrTranscript['start_timestamp'];
            $data['endTimestamp'] = $arrTranscript['end_timestamp'];
            $data['durationMs'] = $arrTranscript['duration_ms'];
            $data['transcript'] = $arrTranscript['transcript'];
            $data['userSentiment'] = $arrTranscript['call_analysis']['user_sentiment'] ?? '';
            $data['callSummary'] = $arrTranscript['call_analysis']['call_summary'] ?? '';
            if (isset($arrTranscript['call_analysis']['custom_analysis_data']['_candidate communication'])) {
                $data['CommunicationScore'] = str_replace('Communication score-', '', $data['call_analysis']['custom_analysis_data']['_candidate communication']);
            } else if (isset($data['call_analysis']['custom_analysis_data']['_communication _analysis'])) {
                $data['CommunicationScore'] = str_replace('Communication score-', '', $data['call_analysis']['custom_analysis_data']['_communication _analysis']);
            } else {
                $data['CommunicationScore'] = '';
            }

            return $data;
            //pre($data);die;
        }
    }


    /**
     * Retrieves contextual interview questions
     * @return array Returns an array of contextual interview questions
     * For now we are hardcoding these questions, but in future we can add these questions from admin panel.
     */
    public function getQuestionsOfContextualInterview()
    {
        $strQuestions = '';
        // $questions = array(
        //     '1' => 'Can you walk me through your sales experience, particularly any work you\'ve done in building materials, construction, or B2B sales?',
        //     '2' => 'I\'d like to understand your approach to achieving targets. Can you tell me about a time when you exceeded your sales target? What specific actions did you take to make that happen?',
        //     '3' => 'Describe a situation where you were behind on your monthly target with just one week left. How did you approach this situation?',
        //     '4' => 'Let\'s say you\'re meeting a new dealer who hasn\'t been buying much from your company. How would you approach this first meeting? Walk me through your strategy.',
        //     '5' => 'If you had to explain Century Ply\'s laminate products to a carpenter who mainly uses competitor products, how would you do it?',
        //     '6' => 'Tell me about your biggest sales success. What was the deal size, how long did it take to close, and what made you successful?',
        //     '7' => 'In this role, you\'ll work with dealers, sub-dealers, contractors, architects, and interior designers. How comfortable are you managing relationships with such diverse stakeholders?',
        //     '8' => 'This role requires managing a territory with multiple locations. How do you typically plan your territory coverage and customer visits?',
        //     '9' => 'Where do you see yourself professionally in the next 3 years? How does this role fit into your career plans?',
        //     '10' => 'What do you know about Century Ply\'s values and culture? How do you see yourself contributing to our team?'
        // );
        $questions = array(
            '1' => 'You receive a patient post-cardiac arrest on a ventilator with unstable vitals. What immediate assessments would you perform, and what information must you communicate to the consultant right away?',
            '2' => 'During your shift, a patient suddenly develops severe hypotension and unresponsiveness. Walk me through the steps you would take in the first 2–3 minutes',
            '3' => 'Can you explain the 10 Rights of medication administration and give an example of how you would handle a situation where a medication order seems incorrect?',
            '4' => 'Suppose you are caring for a patient on mechanical ventilation and you notice condensation in the ventilator tubing. What steps would you take, and why?',
            '5' => 'A family member is anxious and insists on staying beside the patient in the ICU, but it is against hospital policy. How would you handle this situation?'
        );

        foreach ($questions as $key => $question) {
            $strQuestions .= $key . '. ' . $question . "\n";
        }
        //pre($strQuestions);die;
        return $strQuestions;
    }

    public function benchmarkUser($arrData, $arrQA)
    {
        if (empty($arrQA)) {
            echo "No questions and answers found.";
            return;
        }
        $data = [];
        try {
            foreach ($arrQA as $index => $item) {
                // if (isset($item['questionId'])) {
                //     $questionsArray[$item['questionId']] = $item['questionId'] . '. ' . $item['bot'];
                // }
                $data[$index]['botInterviewId'] = $arrData['id'];
                $data[$index]['screeningId'] = $arrData['screeningId'];
                $data[$index]['candidateId'] = $arrData['candidateId'];
                $data[$index]['resumeId'] = $arrData['resumeId']; // Add botInterviewId to data array
                $data[$index]['question'] = $arrQA[$index]['bot'];
                $data[$index]['response'] = $arrQA[$index]['user'];
                $data[$index]['benchmark_response'] = $this->report_model->getBenchmarkResponse($item['questionId']);
            }
            $this->report_model->insertReportData($data);
            echo "Report data benchmark own has been inserted successfully.";
            //  pre($arrBenchmark);die;
        } catch (\Exception $e) {
            echo "An exception occurred: " . $e->getMessage();
            return null;
        }
    }


    public function benchmarkAI($arrData, $arrQA)
    {
        $questionsArray = [];
        pre($arrQA);
        foreach ($arrQA as $index => $item) {
            if (isset($item['questionId'])) {
                $questionsArray[$item['questionId']] = $item['questionId'] . '. ' . $item['bot'];
            }

        }
        // pre($questionsArray);die;
        $prompt = $this->report_model->getPromptsByTitle('Generate_Report_Benchmark');

        $replace = array(
            '{{Candidate_Name}}' => $arrData['candidateName'],
            '{{from - to years}}' => $arrData['experience'],
            '{{Domain}}' => $arrData['domains'],
            '{{Role}} ' => $arrData['role'],
            '{{Admin_Company_Name}}' => 'Adzip',
            '{{questions}}' => implode("\n", $questionsArray),
            '{{Job_Description}}' => $arrData['jdFileContent']
        );

        $prompt = str_replace(array_keys($replace), array_values($replace), $prompt);        // Prepare data for insertion
        try {
            $generatedBenchmark = $this->callEngineLLM($prompt);
            //pre($generatedBenchmark);

            $arrBenchmark = json_decode($generatedBenchmark, true); // true returns associative array
            pre($arrBenchmark);
            //die;
            $benchmarkMap = [];
            if (is_array($arrBenchmark)) {
                foreach ($arrBenchmark as $benchmark) {
                    $questionSeq = $benchmark['Question Sequence'];
                    $benchmarkMap[$questionSeq] = $benchmark['Candidate Response'];
                }
            }
            //pre( $benchmarkMap);die;
            // Step 2: Merge into $data
            foreach ($arrQA as &$item) {
                $qid = $item['questionId'];
                if (isset($benchmarkMap[$qid])) {
                    $item['benchmark_response'] = $benchmarkMap[$qid];
                } else {
                    $item['benchmark_response'] = ''; // or null, or leave unset
                }
            }
            unset($item);
            $data = [];

            foreach ($arrQA as $index => $item) {
                $data[$index]['botInterviewId'] = $arrData['id'];
                $data[$index]['screeningId'] = $arrData['screeningId'];
                $data[$index]['candidateId'] = $arrData['candidateId'];
                $data[$index]['resumeId'] = $arrData['resumeId']; // Add botInterviewId to data array
                $data[$index]['question'] = $arrQA[$index]['bot'];
                $data[$index]['response'] = $arrQA[$index]['user'];
                $data[$index]['benchmark_response'] = $arrQA[$index]['benchmark_response'] ?? '';
            }
            pre($data);
            //die;
            $this->report_model->insertReportData($data);
            //  pre($arrBenchmark);die;
        } catch (\Exception $e) {
            echo "An exception occurred: " . $e->getMessage();
            return null;
        }
    }

    /**
     * Generates question-wise analysis report
     * Processes interview data and generates detailed question-wise analysis.
     */
    public function questionWiseAnalysis($botInterviewId = '')
    {

        $arrQues = [];
        if ($botInterviewId > 0) {
            $arrData = $this->report_model->getDataFromBotInterview($botInterviewId);
            $arrData['stricnessLevel'] = ($arrData['stricnessLevel'] == 'S') ? 'Strict' : 'Generous'; // Default to Medium if not set
            $arrQuestionwise = $this->report_model->getDataFromBotQuestionwise($botInterviewId);
            //pre($arrQuestionwise);
            foreach ($arrQuestionwise as $index => $question) {

                $arrQues[$index]['question_id'] = $question['id'];
                $arrQues[$index]['question'] = $question['question'];
                $arrQues[$index]['candidate_response'] = $question['response'];
                $arrQues[$index]['benchmark_response'] = $question['benchmark_response'] ?? '';
            }
            $arrQues = json_encode($arrQues, JSON_PRETTY_PRINT);
            // pre($arrQuestionwise);
            pre($arrQues);
            //die;
            $prompt = $this->report_model->getPromptsByTitle('Generate_Report_Question_Wise_Analysis');
            //pre(data: $data);die;
            $replace = array(
                '{{App_Name}}' => 'Mira',
                '{{Candidate_Name}}' => $arrData['candidateName'],
                '{{Admin_Company_Name}}' => 'Adzip',
                '{{Domain}}' => $arrData['domains'],
                '{{Strictness_Level}}' => $arrData['stricnessLevel'],
                '{{Questions_Answers_With_Benchmark}}' => $arrQues
            );

            $prompt = str_replace(array_keys($replace), array_values($replace), $prompt);        // Prepare data for insertion
            try {
                $generatedBenchmark = $this->callEngineLLM($prompt);
                //pre($generatedBenchmark);die;
                $arrBenchmark = json_decode($generatedBenchmark, true); // true returns associative array
                pre($arrBenchmark);
                

                if (!empty($arrBenchmark)) {
                    foreach ($arrBenchmark as $index => $param) {
                        $arrFeedbackData = array();
                        $arrFeedbackData = array(
                            'score' => $param['score'],
                            'feedback' => $param['explanation'],
                        );
                        $this->db->where('id', $param['question_id']);
                        $this->db->update('bot_questionwise', $arrFeedbackData);
                        echo "$index . Question-wise analysis updated successfully.";
                        echo "<br>"; // Add a new line for better readability
                        // OR use PHP_EOL constant
                    }

                }
            } catch (\Exception $e) {
                echo "An exception occurred: " . $e->getMessage();
                return null;
            }

        } else {
            show_404();
        }
    }

}