<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Test extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('bot_model');
        $this->load->model('azureblob_model');
    }


    public function index($screeningId)
    {
        $getSettings = $this->bot_model->getSettings($screeningId);
        pre($getSettings);
        die;
        $this->bot_model->generateAudioForQuestion($getSettings);

    }

    public function transcribeAudio()
    {
        try {

            $fileName = 'q614_4_1139_283_20250821_224315.webm';
            $question = "Base language detected: English
चलो, सबसे पहले आपकी clinical nursing care में experience के बारे में बात करते हैं... क्या आप share कर सकते हैं कि आपने अपने पिछले roles में direct patient care कैसे दी है? मुझे जानना है, आप कैसे patients की देखभाल करते थे?";
            $maxRetries = 3;
            $retryDelay = 2; // in seconds
            $retry = 0;

            $arrQ = explode('_', $fileName);
            //extract questionId from the filename
            $questionId = (int) str_replace('q', '', $arrQ[0]);
            $screeningId = $arrQ[3];

            $filePath = FCPATH . 'assets/audio/' . $fileName;
            //echo $filePath;
            while (!file_exists($filePath) && $retry < $maxRetries) {
                sleep($retryDelay);
                $retry++;
            }

            // Check if the file exists
            if (!file_exists($filePath)) {
                return $this->output->set_status_header(404)->set_output(json_encode(['error' => 'Audio file not found']));
            }

            flush();
            $start = microtime(true);
            $getSettings = $this->bot_model->getSettings($screeningId);
            $langId = $this->bot_model->getLanguageId($getSettings);
            $language = $this->bot_model->getLanguages($langId);
            //pre($language);die;

            if ($language['type'] == 'BHASHINI') {
                //use ffmpeg here and convert audio into WAV and send to BHASHINI.
            } else {
                $arrData = $this->bot_model->callEngineSTT($filePath, $language['iso']);

                $transcript = $arrData['transcript'];
            }

            // get duration of the request
            $end = microtime(true);
            $duration = $end - $start;

            // Check if the response is present and then add the questionId and duration to the json data
            if (isset($transcript)) {
                // $transcript = $this->normalizeTranscription($language, $question, $transcript);
                pre($transcript);
                die;
                $updateData = [
                    'questionId' => $questionId,
                    'user' => $transcript,
                    'duration' => $duration
                ];

                // Update the transcript file with the new data
                $this->updateTranscriptFile($updateData);
            } else {
                $updateData = [
                    'questionId' => $questionId,
                    'user' => 'Response didn\'t understand.',
                    'duration' => 0
                ];
                $this->updateTranscriptFile($updateData);
                //error_log("STT API Error Response: " . $body);
            }
        } catch (RequestException $e) {
            echo "Guzzle Exception: " . $e->getMessage() . "\n";

            if ($e->hasResponse()) {
                echo "Error Response:\n" . $e->getResponse()->getBody();
            }
        } catch (Exception $e) {
            echo "General Exception: " . $e->getMessage() . "\n";
        }
    }
    public function normalizeTranscription($language, $question, $transcript)
    {
        $this->db->select('prompt');
        $this->db->from('fill_prompts');
        $this->db->where('title', 'Convert_Transcript_to_Normalisation');
        $promptRow = $this->db->get()->row_array();
        //pre($promptRow); die;// Debugging line, remove in production
        $prompt = isset($promptRow['prompt']) ? $promptRow['prompt'] : '';
        $replace = array(
            '{{Language_Name}}' => $language['language'],
            '{{Question}}' => $question,
            '{{Transcript}}' => $transcript
        );
        $prompt = str_replace(array_keys($replace), array_values($replace), $prompt);        // Prepare data for insertion
        $data = $this->bot_model->callEngineLLM($prompt);
        if (isset($data['response'])) {
            $arrData = json_decode($data['response'], true); // true => associative array
            if (isset($arrData[0])) {
                $normalizedTranscript = $arrData[0]['Response_Transcript'] ?? '';
            }
        }
        // Implement normalization logic here
        return $normalizedTranscript;
    }

    public function checkffmpeg()
    {
        $fileName = "q612_4_1139_283_20250824_140103.webm";
        $filePath = FCPATH . 'assets/audio/' . $fileName;
        $inputFile = $filePath;
        $outputFile = str_replace('webm', 'wav', $filePath);

        // Detect OS if you need different paths
        if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
            $ffmpeg = "C:\\ffmpeg\\bin\\ffmpeg.exe"; // Windows full path
        } else {
            $ffmpeg = "ffmpeg"; // Linux (installed via apt/yum)
        }

        $cmd = $ffmpeg . " -i " . escapeshellarg($inputFile) . " -ar 44100 -ac 2 -f wav " . escapeshellarg($outputFile) . " 2>&1";

        exec($cmd, $output, $return_var);

        if ($return_var === 0) {
            echo "✅ Conversion successful: $outputFile";
            $language['iso'] = 'hi'; // Set your desired language code here
            $arrData = $this->bhashini_model->callBhashiniSTT($outputFile, $language);
        } else {
            echo "❌ Error:\n" . implode("\n", $output);
        }
    }

}