<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
defined('BASEPATH') or exit('No direct script access allowed');
#[\AllowDynamicProperties]
class MY_Controller extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();
		
	}

    public function isValidData($data) {
        // Check if required keys exist in the data array
        if (!empty($data)) {
            $getData = $this->decryptData($data);
            if (!empty($getData['candidateId']) && !empty($getData['resumeId']) && !empty($getData['screeningId'])) {
                return $getData;
            } else {
                log_message('error', 'error: Invalid data parameters');
                $errorData = array(
                    'heading' => 'Invaid Data Parameters',
                    'message' => 'error: Invalid data parameters.'
                );
            $this->load->view('errors/html/error_404', $errorData);
            }
        } else {
            log_message('errors', 'error: No data provided');
            $errorData = array(
                'heading' => 'No data provided',
                'message' => 'error: No data provided.'
            );
            $this->load->view('errors/html/error_404', $errorData);
        }
    }

    public function decryptData($urlSafeEncryptedData) {
        $dataArray = urldecode($this->encryption->decrypt(($urlSafeEncryptedData)));
        $dataArray = unserialize($dataArray);
        return $dataArray;
    }
}