<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class MY_Model extends CI_Model {
    public function getPromptsByTitle($title)
    {
        $this->db->select('prompt');
        $this->db->from('fill_prompts');
        $this->db->where('title', $title);
        $promptRow = $this->db->get()->row_array();
        return isset($promptRow['prompt']) ? $promptRow['prompt'] : '';
    }
	function setCredentials($mail) {
        $mail->isSMTP();
        $mail->SMTPDebug = 0; //values can be 1 to 4.
        $mail->Host = SMTPHOST;
        $mail->SMTPAuth = SMTPAUTH;
        $mail->Username = SMTPUSERNAME;
        $mail->Password = SMTPPWD;
        $mail->SMTPSecure = SMTPSECURE;
        $mail->Port = SMTPPORT;
    }
    
    function cronData($id = "", $cronName="", $params="", $comments="" ) {
        if ($id > 0) {
            $this->db->where('id', $id);
            $this->db->update('tbl_cron_logs', array('status' => 1, 'params'=>$params,'comments'=> $comments));
        } else {
            $this->db->insert('tbl_cron_logs', array('cronName' => $cronName));
            $insertLastId = $this->db->insert_id();
            return $insertLastId;
        }
    }
    
    
    
    
    /**
     * * This function using in both login and register controller.
     * @param type $id
     * @param type $userInfo
     * @return type
     */
      function updateActivationCode($id, $userInfo) {
        $this->db->where('id', $id);
        $this->db->update('register_candidate', $userInfo);
        return $this->db->affected_rows();
    }
    /**
     * This function is use to get activation code in login controller.
     * @param type $email
     * @param type $id
     * @return type
     */
    function getActivationCode($email, $id) {
        $this->db->select('activationCode');
        $this->db->where('email', $email);
        $this->db->where('id', $id);
        $query = $this->db->get('register_candidate')->result_array();
        return $query;
    }
    
    /**
     * This function calling from login controller.
     * @param type $email
     * @param type $password
     * @return type
     */
    
     function updatePasswordUser($userId, $email, $password)
    {
          $this->db->where('id', $userId);
        $this->db->where('email', $email);
        $this->db->update('register_candidate', array('password'=>getHashedPassword($password)));
        return $this->db->affected_rows();
    }
    
    /**
	 * mapping of base url of hire app 
	 */
	public function mappingUrl() {
            $urls = array();
            //$botUrl = "";
            $whitelabelData = whitelabel();
            if (!empty($whitelabelData)) {
                $urls['botUrl'] = $whitelabelData['protocolName'] . "://" . $whitelabelData['botUrl'];
                $urls['uploadResumeUrl'] = $whitelabelData['protocolName'] . "://" . $whitelabelData['intrvuzUrl'];
                $urls['intrvuzUrl'] = $whitelabelData['protocolName'] . "://" . $whitelabelData['intrvuzUrl'];
            } else {
                if (base_url() == 'https://hire.intrvuz.com/') {
                    $urls['botUrl'] = 'https://bot.intrvuz.com';
                    $urls['uploadResumeUrl'] = 'https://app.intrvuz.com';
                    $urls['intrvuzUrl'] = 'https://app.intrvuz.com';
                } else if (base_url() == 'https://hirealpha.intrvuz.com/') {
                    $urls['botUrl'] = 'https://botalpha.intrvuz.com';
                    $urls['uploadResumeUrl'] = 'https://alpha.intrvuz.com';
                    $urls['intrvuzUrl'] = 'https://alpha.intrvuz.com';
                } else if (base_url() == 'https://hiredev.intrvuz.com/') {
                    $urls['botUrl'] = 'https://botdev.intrvuz.com';
                    $urls['uploadResumeUrl'] = 'https://dev.intrvuz.com';
                    $urls['intrvuzUrl'] = 'https://dev.intrvuz.com';
                } else if (base_url() == 'https://hiretest.intrvuz.com/') {
                    $urls['botUrl'] = 'https://bottest.intrvuz.com';
                    $urls['uploadResumeUrl'] = 'https://test.intrvuz.com';
                    $urls['intrvuzUrl'] = 'https://test.intrvuz.com';
                } else {
                    $urls['botUrl'] = 'http://bot.local.in:5000';
                    $urls['uploadResumeUrl'] = 'http://intrvuz.local.in';
                    $urls['intrvuzUrl'] = 'http://intrvuz.local.in';
                }
            }
            return $urls;
        }
}
