<?php

if (!defined('BASEPATH')) exit('No direct script access allowed');

/**
 * This function is used to print the content of any data
 */
function pre($data) {
    echo "<pre>";
    print_r($data);
    echo "</pre>";
}

/**
 * This function used to get the CI instance
 */
if (!function_exists('get_instance')) {

    function get_instance() {
        $CI = &get_instance();
    }

}

/**
 * This function used to generate the hashed password
 * @param {string} $plainPassword : This is plain text password
 */
if (!function_exists('getHashedPassword')) {

    function getHashedPassword($plainPassword) {
        return password_hash($plainPassword, PASSWORD_DEFAULT);
    }

}

/**
 * This function used to generate the hashed password
 * @param {string} $plainPassword : This is plain text password
 * @param {string} $hashedPassword : This is hashed password
 */
if (!function_exists('verifyHashedPassword')) {

    function verifyHashedPassword($plainPassword, $hashedPassword) {
        return password_verify($plainPassword, $hashedPassword) ? true : false;
    }

}

/**
 * This method used to get current browser agent
 */
if (!function_exists('getBrowserAgent')) {

    function getBrowserAgent() {
        $CI = get_instance();
        $CI->load->library('user_agent');

        $agent = '';

        if ($CI->agent->is_browser()) {
            $agent = $CI->agent->browser() . ' ' . $CI->agent->version();
        } else if ($CI->agent->is_robot()) {
            $agent = $CI->agent->robot();
        } else if ($CI->agent->is_mobile()) {
            $agent = $CI->agent->mobile();
        } else {
            $agent = 'Unidentified User Agent';
        }

        return $agent;
    }

}

if (!function_exists('setFlashData')) {

    function setFlashData($status, $flashMsg) {
        $CI = get_instance();
        $CI->session->set_flashdata($status, $flashMsg);
    }

}
function encode_str($str) {
    return urlencode(base64_encode($str));
}

function decode_str($str) {
    return base64_decode(urldecode($str));
}



 /*Whitelabel*/
    function whitelabel($whitelabelId=0){
        $CI = & get_instance();
        $CI->load->database();
        $data = array();
        $where = "";
        $host = $_SERVER['HTTP_HOST'];
        if($whitelabelId>0){
            $where .= "id=$whitelabelId";
        }else{
            $where .="hireUrl = '$host'";
        }
        $sql = "SELECT * from register_whitelabel where $where";
        $query = $CI->db->query($sql);
        // Fetching results as an array
        $result = $query->result_array();
        if(!empty($result)){
           $data =  $result[0];
        }
        return $data;
    }

?>
