<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Activity_check {

    protected $CI;

    public function __construct() {
        $this->CI =& get_instance();
        $this->CI->load->library('session');
    }

    public function check_activity() {
        // Logout threshold in seconds
        $timeout = 10 * 60; // 10 minutes

        // Check if user is logged in
        if ($this->CI->session->userdata('isLoggedIn')) {
            $last_activity = $this->CI->session->userdata('lastActivityTime') ?: time();
            $current_time = time();

            if (($current_time - $last_activity) > $timeout) {
                // If inactive for too long, log out the user
                $this->CI->session->unset_userdata('isLoggedIn');
                $this->CI->session->unset_userdata('lastActivityTime');
                $this->CI->session->sess_destroy();
                redirect('login'); // Adjust the redirection path to your login page
            } else {
                // Update the last activity time
                $this->CI->session->set_userdata('lastActivityTime', $current_time);
            }
        }
    }
}
