<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Captcha
{
    public function generate()
    {
        // Load CodeIgniter's built-in image library
        $CI =& get_instance();
        $CI->load->helper('captcha');

        // Define CAPTCHA settings
		$config = array(
			'img_path'      => './uploads/captcha/', // Ensure this directory exists and is writable
			'img_url'       => base_url('uploads/captcha/'), // Correct the URL to the uploads directory
			'font_path'     => '', // Use default system font unless a valid font path is provided
			'img_width'     => 200, // Ensure this is an integer
			'img_height'    => 50,  // Ensure this is an integer
			'expiration'    => 7200, // Expiration in seconds
			'word_length'   => 5,    // Length of the CAPTCHA word
			'font_size'     => 200,   // Font size
			'img_id'        => 'Imageid',
			
			'pool'          => 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789',
			'colors'        => array(
				'background' => array(255, 255, 255),
				'border'     => array(204, 204, 204),
				'text'       => array(0, 0, 0),
				'grid'       => array(255, 40, 40)
			)
		);

        // Generate the CAPTCHA 
		
        $captcha = create_captcha($config);

        // Store the CAPTCHA word in the session
        $CI->session->set_userdata('captcha_word', $captcha['word']);

        return $captcha;
    }
}
