<?php
defined('BASEPATH') or exit('No direct script access allowed');
require 'vendor/autoload.php';

use MicrosoftAzure\Storage\Common\Internal\Resources;

use MicrosoftAzure\Storage\Blob\BlobRestProxy;
use MicrosoftAzure\Storage\Common\Exceptions\ServiceException;
use MicrosoftAzure\Storage\Blob\BlobSharedAccessSignatureHelper;
//use MicrosoftAzure\Storage\Common\Internal\StorageServiceSettings;
use MicrosoftAzure\Storage\Blob\Models\GetBlobOptions;

class Azureblob_model extends MY_Model {

    /*This function is use for store files in container in Azure Blob.*/
    public function azureBlobUpload($containerName, $fileName, $content) {
        $connectionString = BLOBSTORAGECONNECTIONSTRING;
            
        $blobClient = BlobRestProxy::createBlobService($connectionString);
        try {
            // Directly upload the file as a blob
            $blobClient->createBlockBlob($containerName, $fileName, $content);
            //echo "File '$fileName' uploaded successfully to Azure Blob Storage.";
            return 'SUCCESS';
        } catch (ServiceException $e) {
               // Azure-specific errors
            $code = $e->getCode();
            $message = $e->getMessage();
            log_message('error', "Azure Blob ServiceException [$code]: $message");
            return "Azure Error [$code]: $message";
        }
    }
    
    /*This function is use for get file from container in Azure Blob with stram but without SAS Token .*/
    public function getBlobStreamFromAzureBlob($containerName, $fileName) {
	$connectionString = BLOBSTORAGECONNECTIONSTRING;
	$blobClient = BlobRestProxy::createBlobService($connectionString);
        $blob = $blobClient->getBlob($containerName, $fileName);
        $stream = $blob->getContentStream();
        return $stream;
    }
    

    public function generateSASToken($containerName, $blobName) {
           // Create the blob client
        $accountName = BLOBACCOUNTNAME;
        $accountKey = BLOBACCOUNTKEY;
        $blobClient = BlobRestProxy::createBlobService(
            "DefaultEndpointsProtocol=https;AccountName=$accountName;AccountKey=$accountKey;EndpointSuffix=core.windows.net"
        );

        // Create the SAS Helper
        $sasHelper = new BlobSharedAccessSignatureHelper($accountName, $accountKey);

        // Set expiry time (e.g., 1 hour from now)
        $expiryTime = gmdate('Y-m-d\TH:i:s\Z', strtotime('+1 hour'));

        // Permissions: 'r' = read
        $permissions = 'r';

        // Generate the SAS token
        $sasToken = $sasHelper->generateBlobServiceSharedAccessSignatureToken(
            'b', // ✅ This must be exactly 'b'
            "$containerName/$blobName", // ✅ Must be in format: container/blob
            'r', // Read permission
            $expiryTime
        );

        // Final URL
        $mp3Url = sprintf(
            'https://%s.blob.core.windows.net/%s/%s?%s',
            $accountName,
            $containerName,
            $blobName,
            $sasToken
        );

        return $mp3Url;
        }
}