<?php
require_once APPPATH . 'third_party/vendor/autoload.php';

defined('BASEPATH') or exit('No direct script access allowed');

class Bhashini_model extends MY_Model
{
    private $BHASHINIURL;
    private $PIPELINEID;
    private $ULCAAPIKEY;
    private $USERID;
    private $GENDER;

    public function __construct()
    {
        parent::__construct();
        $this->BHASHINIURL = "https://meity-auth.ulcacontrib.org/ulca/apis/v0/model/getModelsPipeline";
        $this->PIPELINEID = '64392f96daac500b55c543cd';
        $this->ULCAAPIKEY = '34a6676337-0da9-486f-aeea-fb222f9eaed7';
        $this->USERID = '49ab64463c104363a55546c7b6831ff8';
        $this->GENDER = 'female';
    }

    public function generateAllQuestionsBhashini($getSettings, $questionsArray, $language)
    {
        //pre($questionsArray);die;
        $idMap = [];
        $arrQuesForBhashini = [];

        if (!empty($questionsArray)) {
            foreach ($questionsArray as $ques) {
                $idMap[] = $ques['id']; // store id separately
                $arrQuesForBhashini[] = ['source' => trim($ques['question'])];
            }
        }
        //pre($arrQuesForBhashini);die;
        $lang['sourceLanguage'] = 'en';
        $lang['targetLanguage'] = $language['iso'];
        //pre($lang);die;
        $taskType = "translation";
        $payload = $this->pipeLineConfigCall($lang, $taskType);
        if (!empty($payload)) {
            $computeData = $this->pipeLineComputeCall($lang, $taskType, $payload, $arrQuesForBhashini);
            if (!empty($computeData)) {
                $computeData = $computeData['output'];
                foreach ($computeData as $index => $item) {
                    $data = array(
                        'originalQuestionId' => $idMap[$index],
                        'screeningId' => $getSettings['screeningId'],
                        'langId' => $language['id'],
                        'question' => $item['target'], // or whatever key your API returns
                        'created' => date('Y-m-d H:i:s')
                    );
                    //pre($data);
                    $this->db->insert('questions_vernacular', $data);
                }
            }
        }
    }


    /**
     * This function is use for pipeline config call. 
     * In Bhashini firstly call pipe line config call
     * Return service ID and pipelineInferenceAPIEndPoint 
     */

    public function pipeLineConfigCall($lang, $taskType)
    {
        // Create params as PHP array that will be automatically converted to JSON
        if ($taskType == 'translation') {
            $arrLang = array("sourceLanguage" => $lang['sourceLanguage'], "targetLanguage" => $lang['targetLanguage']);
        } else {
            $arrLang = array("sourceLanguage" => $lang['sourceLanguage']);
        }
        $params = [
            "pipelineTasks" => [
                [
                    "taskType" => $taskType,
                    "config" => [
                        "language" => $arrLang
                    ]
                ]
            ],
            "pipelineRequestConfig" => [
                "pipelineId" => $this->PIPELINEID
            ]
        ];

        try {
            $client = new \GuzzleHttp\Client();

            $response = $client->request('POST', $this->BHASHINIURL, [
                'headers' => [
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json',
                    'ulcaApiKey' => $this->ULCAAPIKEY,
                    'userID' => $this->USERID
                ],
                'json' => $params,  // Guzzle will automatically encode this to JSON
                'on_stats' => function (\GuzzleHttp\TransferStats $stats) {
                    //echo "GuzzleHTTPERROR-->".$stats->getEffectiveUri();
                }
            ]);

            $body = $response->getBody()->getContents();

            $data = json_decode($body, true);
            // pre($data);die;
            $payload = array();
            if (isset($data['pipelineResponseConfig']) && isset($data['pipelineInferenceAPIEndPoint'])) {
                $payload['serviceId'] = $data['pipelineResponseConfig'][0]['config'][0]['serviceId'];
                $payload['callbackUrl'] = $data['pipelineInferenceAPIEndPoint']['callbackUrl'];
                $payload['inferenceApiKeyName'] = $data['pipelineInferenceAPIEndPoint']['inferenceApiKey']['name'];
                $payload['inferenceApiKeyValue'] = $data['pipelineInferenceAPIEndPoint']['inferenceApiKey']['value'];
                return $payload;
            } else {
                log_message('error', 'Invalid response format from Bhashini API');
                return null;
            }
        } catch (\Exception $e) {
            log_message('error', 'Bhashini API Error: ' . $e->getMessage());
            return null;
        }
    }

    /**
     * Secondly we uses pipeline compute call.
     */
    public function pipeLineComputeCall($lang, $taskType, $payload, $arrQuesForBhashini)
    {
        // Only handle translation task type
        if ($taskType != 'translation') {
            log_message('error', 'Invalid task type for pipeLineComputeCall: ' . $taskType);
            return null;
        }

        $arrLang = array(
            "sourceLanguage" => $lang['sourceLanguage'], 
            "targetLanguage" => $lang['targetLanguage']
        );

        $params = [
            "pipelineTasks" => [
                [
                    "taskType" => $taskType,
                    "config" => [
                        "language" => $arrLang,
                        "serviceId" => $payload['serviceId']
                    ]
                ]
            ],
            "inputData" => [
                "input" => $arrQuesForBhashini
            ]
        ];

        try {
            $client = new \GuzzleHttp\Client();

            $response = $client->request('POST', $payload['callbackUrl'], [
                'headers' => [
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json',
                    $payload['inferenceApiKeyName'] => $payload['inferenceApiKeyValue']
                ],
                'json' => $params
            ]);

            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);

            if (isset($data['pipelineResponse'][0])) {
                return $data['pipelineResponse'][0];
            } else {
                log_message('error', 'Invalid response format from Bhashini API');
                return null;
            }
        } catch (\Exception $e) {
            log_message('error', 'Bhashini API Error: ' . $e->getMessage());
            return null;
        }
    }

    public function callBhashiniTTS($arrQuestion, $getSettings, $language)
    {
        try {
            // 1. Validate inputs
            if (empty($arrQuestion['question'])) {
                throw new Exception("Question text is required");
            }

            // 2. Configure language and get pipeline
            $lang['sourceLanguage'] = $language['iso'];
            $taskType = "tts";
            $payload = $this->pipeLineConfigCall($lang, $taskType);

            if (empty($payload)) {
                throw new Exception("Failed to get pipeline configuration");
            }

            // 3. Prepare text data and build compute payload
            $textToConvert = trim($arrQuestion['question']);
            $arrComputeData = [
                "pipelineTasks" => [
                    [
                        "taskType" => $taskType,
                        "config" => [
                            "language" => [
                                "sourceLanguage" => $lang['sourceLanguage']
                            ],
                            "serviceId" => $payload['serviceId'],
                            "gender" => $this->GENDER,
                            "samplingRate" => 16000,
                            "audioFormat" => "mp3"
                        ]
                    ]
                ],
                "inputData" => [
                    "input" => [
                        [
                            "source" => $textToConvert
                        ]
                    ]
                ]
            ];

            // 4. Make API call
            $client = new \GuzzleHttp\Client([
                'timeout' => 30
            ]);

            $response = $client->request('POST', $payload['callbackUrl'], [
                'headers' => [
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json',
                    $payload['inferenceApiKeyName'] => $payload['inferenceApiKeyValue']
                ],
                'json' => $arrComputeData
            ]);

            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);

            // 5. Validate response
            if (!isset($data['pipelineResponse'][0]['audio'][0]['audioContent'])) {
                log_message('error', 'Invalid TTS response format: ' . json_encode($data));
                throw new Exception("Invalid response format from Bhashini API");
            }

            // 6. Process and save audio file
            $audioContent = $data['pipelineResponse'][0]['audio'][0]['audioContent'];
            $fileName = "bhashini_" . $arrQuestion['screeningId'] . '_' . $language['id'] . '_' . time() . '.mp3';
            $path = FCPATH . '/assets/questions_audios/' . $fileName;

            $audioData = base64_decode($audioContent);
            if (file_put_contents($path, $audioData) === false) {
                throw new Exception("Failed to save audio file");
            }

            // 7. Return file details
            return [
                'fileName' => $fileName,
                'path' => $path
            ];

        } catch (\Exception $e) {
            log_message('error', 'Bhashini TTS Error: ' . $e->getMessage());
            log_message('error', 'Request payload: ' . json_encode($arrComputeData ?? []));
            return null;
        }
    }

    /**
     * This function is use to trancribe audio files.
     */
    public function callBhashiniSTT($audioFilePath, $language) 
    {
        try {
            // Remove any output buffering
            
            // 1. Validate file and language
            if (!file_exists($audioFilePath)) {
                echo "Audio file not found: " . $audioFilePath;
                throw new Exception("Audio file not found: " . $audioFilePath);
            }

            if (!is_array($language) || !isset($language['iso'])) {
                echo "Invalid language format";
                throw new Exception("Invalid language format");
            }
            //echo "<<<<".$audioFilePath;die;
            // 2. Get file info
            $fileInfo = pathinfo($audioFilePath);
            $audioFormat = strtolower($fileInfo['extension']);
            
            // 3. Configure language and get pipeline
            $lang = array('sourceLanguage' => $language['iso']);
            $taskType = "asr";
            $payload = $this->pipeLineConfigCall($lang, $taskType);

            if (empty($payload)) {
                throw new Exception("Failed to get pipeline configuration");
            }

            // 4. Prepare audio data
            $audioData = file_get_contents($audioFilePath);
            if ($audioData === false) {
                throw new Exception("Failed to read audio file");
            }
            $audioBase64 = base64_encode($audioData);

            // 5. Build compute payload
            $arrComputeData = [
                "pipelineTasks" => [
                    [
                        "taskType" => $taskType,
                        "config" => [
                            "language" => [
                                "sourceLanguage" => $lang['sourceLanguage']
                            ],
                            "serviceId" => $payload['serviceId'],
                            "audioFormat" => $audioFormat,
                            "samplingRate" => 16000
                        ]
                    ]
                ],
                "inputData" => [
                    "audio" => [
                        [
                            "audioContent" => $audioBase64
                        ]
                    ]
                ]
            ];
            // 6. Make API call
            $client = new \GuzzleHttp\Client([
                'timeout' => 60 // Increased timeout
            ]);

            $response = $client->request('POST', $payload['callbackUrl'], [
                'headers' => [
                    'Content-Type' => 'application/json',
                    'Accept' => 'application/json',
                    $payload['inferenceApiKeyName'] => $payload['inferenceApiKeyValue']
                ],
                'json' => $arrComputeData
            ]);

            $body = $response->getBody()->getContents();
            $data = json_decode($body, true);
           // pre($data);die;
            // Add debug logging
            log_message('debug', 'STT Response: ' . json_encode($data));

            // 7. Validate response structure
            if (!is_array($data) || 
                !isset($data['pipelineResponse']) || 
                !is_array($data['pipelineResponse']) ||
                !isset($data['pipelineResponse'][0]['output'][0]['source'])) {
                throw new Exception("Invalid response structure from Bhashini API");
            }
echo $data['pipelineResponse'][0]['output'][0]['source'];
            // 8. Return transcribed text
            return $data['pipelineResponse'][0]['output'][0]['source'];

        } catch (\Exception $e) {
            log_message('error', 'Bhashini STT Error: ' . $e->getMessage());
            log_message('error', 'Request payload: ' . json_encode($arrComputeData ?? []));
            return null;
        }
    }
}