<?php

use PhpParser\Node\Stmt\Echo_;
require_once APPPATH . 'third_party/vendor/autoload.php';

defined('BASEPATH') or exit('No direct script access allowed');

class Report_model extends MY_Model
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('azureblob_model');
    }

    

    public function getBenchmarkResponse($questionId = "")
    {
        $this->db->select('benchmarkResponse');
        $this->db->from('questions_vernacular');
        $this->db->where('id', $questionId);
        $query = $this->db->get()->row_array();
        if (!empty($query)) {
            return $query['benchmarkResponse'];
        } else {
            return null;
        }
    }
    public function getDataFromBotInterview($botInterviewId)
    {
        $this->db->select('bi.*, c.name as candidateName, c.mobile, s.jdFileContent,s.domains, s.experience, 
            s.stricnessLevel,fr.role,sbs.interviewType,sbs.benchmarkType,sbs.isContextual, sbs.gpt, sbs.proctoring, sbs.voiceType, 
            sbs.vernacularResponse, sbs.interviewLanguage, rg.resumeSkillResponse');
        $this->db->from('bot_interview bi');
        $this->db->join('register_candidate c', 'c.id = bi.candidateId', 'left');
        $this->db->join('resume r', 'r.id = bi.resumeId', 'left');
        $this->db->join('resume_gpt_response rg', 'rg.resumeId = r.id', 'left');
        $this->db->join('screening s', 's.id = bi.screeningId', 'left');
        $this->db->join('screening_bot_settings sbs', 'sbs.screeningId = s.id', 'left');
        $this->db->join('fill_roles fr', 'fr.id = s.roleId', 'left');
        $this->db->where('bi.id', $botInterviewId);
        $query = $this->db->get();
        return $query->row_array();
    }

    public function insertReportData($data)
    {
        //pre($data);die;
        $botInterviewId = $data[0]['botInterviewId'];

        $sql = "DELETE FROM bot_questionwise WHERE botInterviewId = ?";
        $this->db->query($sql, [$botInterviewId]);

        if (empty($data)) {
            return false;
        } else {
            foreach ($data as $item) {
                $data1['botInterviewId'] = $item['botInterviewId'];
                $data1['screeningId'] = $item['screeningId'];
                $data1['candidateId'] = $item['candidateId'];
                $data1['resumeId'] = $item['resumeId'];
                $data1['question'] = $item['question'];
                $data1['response'] = $item['response'];
                $data1['benchmark_response'] = $item['benchmark_response'] ?? '';
                $this->db->insert('bot_questionwise', $data1);
            }
            echo "Benchmark through data inserted successfully.";
        }

    }

    public function getDataFromBotQuestionwise($botInterviewId)
    {
        $this->db->select('bq.*');
        $this->db->from('bot_questionwise bq');
        $this->db->where('bq.botInterviewId', $botInterviewId);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function insertScoringData($data)
    {
        $botInterviewId = $data[0]['botInterviewId'];

        $sql = "DELETE FROM bot_overall_scores WHERE botInterviewId = ?";
        $this->db->query($sql, [$botInterviewId]);

        if (empty($data)) {
            return false;
        } else {
            foreach ($data as $item) {
                $this->db->insert('bot_overall_scores', $item);
            }
            echo "Scoring data inserted successfully.";
        }

    }

    public function getDataFromBotRetell($botInterviewId)
    {
        $this->db->select('*');
        $this->db->from('bot_retell');
        $this->db->where('botInterviewId', $botInterviewId);
        $query = $this->db->get();
        return $query->row_array();
    }

      public function formatSkills($skills) {
    $formattedSkills = [];
    
    if (!empty($skills)) {
        // Handle primary skills
        if (isset($skills['primary_skills']) && is_array($skills['primary_skills'])) {
            $formattedSkills['primary_skills'] = array_map(function($skill) {
                // Split skill and score
                $parts = explode(':', trim($skill));
                $skillName = trim($parts[0]);
                $score = isset($parts[1]) ? trim($parts[1]) : '0/10';
                return $skillName;
                
            }, $skills['primary_skills']);
        }
        
        // Handle secondary skills
        if (isset($skills['secondary_skills']) && is_array($skills['secondary_skills'])) {
            $formattedSkills['secondary_skills'] = array_map(function($skill) {
                // Split skill and score
                $parts = explode(':', trim($skill));
                $skillName = trim($parts[0]);
                $score = isset($parts[1]) ? trim($parts[1]) : '0/10';
                
                return $skillName;
            }, $skills['secondary_skills']);
        }
    }
    // $stringifiedSkills = '';
    // $i=13;
    // foreach($formattedSkills['primary_skills'] as $key => $skillsArray) {
    //     $stringifiedSkills .= $i.". ".$skillsArray." (10 Marks)\n";
    //     $i++;
    // }
    // foreach($formattedSkills['secondary_skills'] as $key => $skillsArray) {
    //     $stringifiedSkills .= $i.". ".$skillsArray." (10 Marks)\n";
    //     $i++;
    // }
    //pre($stringifiedSkills);die;
    //pre($formattedSkills);die;
    return $formattedSkills;
}
}
