<?php $this->load->view('templates/header'); ?>

<div id="app-container">
    <div class="attire-check-container">
        <!-- Top Section: Title and Instructions -->
        <h2 class="attire-title">Identity Verification</h2>
        <p class="attire-instructions">Align your body within the frame. Photo will be captured after a 5-second countdown.</p>
        
        <!-- Main Content: This row will now be vertically centered -->
        <div class="attire-preview-row">
            <!-- Left Panel: Contains the camera AND the capture button -->
            <div class="attire-camera-box">
                <div class="attire-camera-container">
                    <video id="attireVideo" autoplay muted playsinline></video>
                </div>
                <button id="startCountdownBtn" class="attire-btn primary">Capture</button>
            </div>

            <!-- Right Panel: Contains the preview AND the countdown timer -->
            <div class="attire-preview-box">
                <div class="attire-preview-container">
                    <div id="attirePreview" class="attire-preview-placeholder">
                            <svg width="120" height="180" viewBox="0 0 120 180">
                                <g stroke="#007bff" stroke-width="3" fill="none" opacity="0.7">
                                    <!-- Head -->
                                    <circle cx="60" cy="25" r="15"/>
                                    <!-- Body -->
                                    <rect x="45" y="40" width="30" height="60" rx="5"/>
                                    <!-- Arms -->
                                    <rect x="25" y="50" width="12" height="40" rx="6"/>
                                    <rect x="83" y="50" width="12" height="40" rx="6"/>
                                    <!-- Legs -->
                                    <rect x="48" y="100" width="8" height="35" rx="4"/>
                                    <rect x="64" y="100" width="8" height="35" rx="4"/>
                                </g>
                            </svg>
                    </div>
                    <img id="capturedAttireImage" class="hidden" alt="Captured Attire" />
                </div>
                <div id="countdown" class="countdown-display hidden">5</div>
            </div>
        </div>

        <!-- Bottom Section: This container has the top border -->
        <div class="attire-bottom-buttons">
            <button class="attire-btn secondary" onclick="goBack()">Back</button>
            <button id="continueBtn" class="attire-btn primary" onclick="continueToNext()" disabled>Next</button>
        </div>
            <div id="loader" style="display: none;">
            <div class="spinner"></div>
            <center><div>Processing...</div></center>
        </div>
        <canvas id="attireCanvas" class="hidden"></canvas>
    </div>
</div>

<script>
const attireVideo = document.getElementById("attireVideo");
const canvas = document.getElementById("attireCanvas");
const ctx = canvas.getContext("2d");
const startCountdownBtn = document.getElementById("startCountdownBtn");
const countdownDisplay = document.getElementById("countdown");
const attirePreview = document.getElementById("attirePreview");
const capturedImage = document.getElementById("capturedAttireImage");
const continueBtn = document.getElementById("continueBtn");
const BASE_URL = "<?php echo base_url(); ?>";

let isCountingDown = false;
let hasCaptured = false;
let countdownTimer = null;

// Initialize camera
navigator.mediaDevices.getUserMedia({ 
    video: { 
        width: { ideal: 480 },
        height: { ideal: 640 },
        aspectRatio: { ideal: 0.75 } // 3:4 aspect ratio for portrait
    } 
})
    .then(stream => {
        attireVideo.srcObject = stream;
    })
    .catch(err => {
        console.error("Camera access denied:", err);
        alert("Camera access is required for attire verification");
    });

// Show/hide elements
function showElement(element) {
    element.classList.remove('hidden');
}

function hideElement(element) {
    element.classList.add('hidden');
}

// Start countdown and capture
startCountdownBtn.addEventListener("click", () => {
    if (hasCaptured) {
        // Reset if already captured
        resetCapture();
        return;
    }
    
    if (isCountingDown) return;
    
    startCountdown();
});

function startCountdown() {
    isCountingDown = true;
    startCountdownBtn.disabled = true;
    showElement(countdownDisplay);
    
    let count = 5;
    countdownDisplay.textContent = count;
    
    countdownTimer = setInterval(() => {
        count--;
        if (count > 0) {
            countdownDisplay.textContent = count;
        } else {
            clearInterval(countdownTimer);
            capturePhoto();
        }
    }, 1000);
}

function capturePhoto() {
    // Set canvas dimensions to match video
    canvas.width = attireVideo.videoWidth;
    canvas.height = attireVideo.videoHeight;
    
    // Draw video frame to canvas
    ctx.drawImage(attireVideo, 0, 0, canvas.width, canvas.height);
    
    // Get image data
    const imageDataURL = canvas.toDataURL("image/jpeg", 0.8);
    
    // Display captured image
    capturedImage.src = imageDataURL;
    showElement(capturedImage);
    hideElement(attirePreview);
    
    // Update UI
    hideElement(countdownDisplay);
    startCountdownBtn.textContent = "Retake";
    startCountdownBtn.disabled = false;
    isCountingDown = false;
    hasCaptured = true;
    continueBtn.disabled = false;
    // Store the captured image data for potential upload
    window.capturedAttireData = imageDataURL.split(",")[1]; // Base64 data
}

function resetCapture() {
    // Reset to initial state
    hideElement(capturedImage);
    showElement(attirePreview);
    startCountdownBtn.textContent = "Capture";
    hasCaptured = false;
    continueBtn.disabled = true;
    window.capturedAttireData = null;
    
    // Clear any running countdown
    if (countdownTimer) {
        clearInterval(countdownTimer);
    }
    hideElement(countdownDisplay);
    isCountingDown = false;
    startCountdownBtn.disabled = false;
}

function continueToNext() {
    if (!hasCaptured) {
        alert("Please capture your photo before continuing");
        return;
    }
    
    // Show loader
    document.getElementById("loader").style.display = "block";
    
    // Optional: Send attire data to server for verification
    // You can implement server-side attire checking here
    
    // For now, just proceed to next step

    // Send captured image to your PHP backend
    fetch("<?php echo base_url('analyze/attireCheck'); ?>", {
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        body: JSON.stringify({
            image: window.capturedAttireData
        })
    })
    .then(response => response.text())
    .then(data => {
        document.getElementById("loader").style.display = "none";
        // alert(data);
        // if (data.error) {
        //     alert("Error: " + data.error + "data Error");
        //     return;
        // }

        // const result = data.result || data;  // depends on what engine returns
        // const dressCode = result.dress_code || "unknown";

        // alert(`Attire detected: ${dressCode.toUpperCase()}`);

        location.href = "<?php echo base_url('bot/redirectToPage/attire?data=' . $this->input->get('data')) ?>";
    })
    .catch(error => {
        document.getElementById("loader").style.display = "none";
        console.error("Identity check failed:", error);
        alert("Failed to verify identity. Please try again.");
    });

}

function goBack() {
    // Stop camera stream before going back
    if (attireVideo.srcObject) {
        const tracks = attireVideo.srcObject.getTracks();
        tracks.forEach(track => track.stop());
    }
    history.back();
}

// Cleanup on page unload
window.addEventListener('beforeunload', () => {
    if (attireVideo.srcObject) {
        const tracks = attireVideo.srcObject.getTracks();
        tracks.forEach(track => track.stop());
    }
});
</script>