<?php $this->load->view('templates/header'); ?> 
<div class="fraud-body">
    <div class="fraud-container">
        <div class="fraud-header">
            <h2 class="fraud-title">Identity Verification</h2>
        </div>
        <div class="fraud-instructions">
            <p>Please upload your ID & click "Capture" to take selfie. Ensure you are in a well-lit room.</p>
        </div>
        
        <div class="fraud-preview-row">
            <!-- Left Section: Upload ID & Click your picture -->
            <div id="fraud-video-container">
                <h3>Upload ID & Click your picture</h3>
                <div class="fraud-video-box">
                    <input type="file" id="idImageInput" accept="image/*" />
                    <video id="selfieVideo" autoplay muted playsinline></video>
                    <div class="fraud-capture-btn">
                        <button id="captureSelfieBtn" class="get-started-btn">Capture</button>
                    </div>
                </div>
                <!-- MODIFIED: "Or do it via mobile" is now a link -->

            </div>
            <!-- Right Section: Single preview with verification -->
            <div id="fraud-preview-container">
                <h3>Your Captured Selfie</h3>
                <div class="fraud-upload-box">
                    <img id="combinedPreview" alt="User Preview" src="<?php echo base_url(); ?>assets/images/placeholder.png" />
                    <p id="result" class="verification-result"></p>
                </div>
            </div>
        </div>

        <!-- Bottom controls positioned in bottom right -->
        <div class="fraud-bottom-buttons">
            <p class="mobile-note">
                <a href="<?php echo base_url('bot/mobileVerify?data=' . $this->input->get('data')); ?>" class="mobile-link">
                    Or do it via mobile
                </a>
            </p>         
            <div class="fraud-bottom-buttons-right">
                <button class="back-btn" onclick="goBack()">Back</button>
                <button id="MPbutton" class="get-started-btn">Verify</button>
            </div>
        </div>
        <canvas id="selfieCanvas" style="display: none;"></canvas>

        <div id="loader" style="display: none;">
            <div class="spinner"></div>
            <div>Verifying...</div>
        </div>
    </div>
</div>

<script>
const selfieVideo = document.getElementById("selfieVideo");
const canvas = document.getElementById("selfieCanvas");
const ctx = canvas.getContext("2d");
const captureBtn = document.getElementById("captureSelfieBtn");
const combinedPreview = document.getElementById("combinedPreview");
const idInput = document.getElementById("idImageInput");
const BASE_URL = "<?php echo base_url(); ?>";

const placeholderSrc = "<?php echo base_url(); ?>assets/images/placeholder.png";
// Initialize variables
let capturedSelfie = null;
let hasCaptured = false;
let isVerified = false;

navigator.mediaDevices.getUserMedia({ video: true })
    .then(stream => selfieVideo.srcObject = stream)
    .catch(err => {
        console.error("Camera access error:", err);
        alert("Camera access is required for identity verification. Please allow camera access and refresh the page.");
    });

// Handle ID image upload (no preview change, just for submission)
idInput.addEventListener("change", (e) => {
    // Logic can be added here if needed when a file is selected
});

// captureBtn.addEventListener("click", () => {
//     if (!hasCaptured) {
//         canvas.width = selfieVideo.videoWidth;
//         canvas.height = selfieVideo.videoHeight;
//         ctx.drawImage(selfieVideo, 0, 0, canvas.width, canvas.height);
//         capturedSelfie = canvas.toDataURL("image/jpeg").split(",")[1];
//         combinedPreview.src = "data:image/jpeg;base64," + capturedSelfie;
//         hasCaptured = true;
//         captureBtn.textContent = "Retake";
//     } else {
//         capturedSelfie = null;
//         combinedPreview.src = placeholderSrc;
//         hasCaptured = false;
//         captureBtn.textContent = "Capture";
//     }
// });

captureBtn.addEventListener("click", () => {
    if (!hasCaptured) {
        const videoRect = selfieVideo.getBoundingClientRect();
        const videoAspectRatio = videoRect.width / videoRect.height;

        const videoWidth = selfieVideo.videoWidth;
        const videoHeight = selfieVideo.videoHeight;
        const videoFeedAspectRatio = videoWidth / videoHeight;

        let sx, sy, sWidth, sHeight;

        if (videoFeedAspectRatio > videoAspectRatio) {
            // Feed is wider than display: crop sides
            sHeight = videoHeight;
            sWidth = sHeight * videoAspectRatio;
            sx = (videoWidth - sWidth) / 2;
            sy = 0;
        } else {
            // Feed is taller than display: crop top/bottom
            sWidth = videoWidth;
            sHeight = sWidth / videoAspectRatio;
            sx = 0;
            sy = (videoHeight - sHeight) / 2;
        }

        canvas.width = videoRect.width;
        canvas.height = videoRect.height;

        ctx.drawImage(selfieVideo, sx, sy, sWidth, sHeight, 0, 0, canvas.width, canvas.height);
        
        capturedSelfie = canvas.toDataURL("image/jpeg").split(",")[1];
        combinedPreview.src = "data:image/jpeg;base64," + capturedSelfie;
        hasCaptured = true;
        captureBtn.textContent = "Retake";
        

    } else {
        capturedSelfie = null;
        combinedPreview.src = placeholderSrc;
        hasCaptured = false;
        captureBtn.textContent = "Capture";
        document.getElementById("idImageInput").value = "";
        document.getElementById("MPbutton").textContent = "Verify";
    }
});

document.getElementById("MPbutton").addEventListener("click", async () => {
    const buttonText = document.getElementById("MPbutton").textContent;
    //console.log(buttonText); // Output: "Verify"
    if(!isVerified && buttonText=='Verify'){
        const idFile = idInput.files[0];
        if (!idFile || !capturedSelfie) {
            alert("Please upload an ID and capture a selfie before verifying.");
            return;
        }
        document.getElementById("loader").style.display = "block";

        const reader = new FileReader();
        reader.onloadend = async () => {
            const idBase64 = reader.result.split(",")[1];
            try{
                const res = await fetch(`${BASE_URL}/analyze/verifyIdentity`, {
                    method: "POST",
                    headers: { "Content-Type": "application/json" },
                    body: JSON.stringify({
                        id_image: idBase64,
                        selfie: capturedSelfie
                    })
                });

                const data = await res.json();
                
                const resultText = data.verified
                    ? `✅ Identity verified`
                    : `❌ Identity mismatch`;
                isVerified = data.verified;
                document.getElementById("result").textContent = resultText;
                document.getElementById("result").style.color = data.verified ? 'green' : 'red';
                document.getElementById("MPbutton").textContent = "Next";
                // if(isVerified){
                //     document.getElementById("MPbutton").textContent = "Next";
                // }
            } catch (error) {
                document.getElementById("result").textContent = "❌ Error verifying identity.";
                document.getElementById("result").style.color = 'red';
                console.error("Verification error:", error);
            } finally {
                document.getElementById("loader").style.display = "none";
            }
        };
        
        reader.readAsDataURL(idFile);
    }else{
        location.href = "<?php echo base_url('bot/redirectToPage/identityVerify?data=' . $this->input->get('data')) ?>";
    }
});


function prepare() {
   location.href = "<?php echo base_url('bot/redirectToPage/identityVerify?data=' . $this->input->get('data')) ?>";
}

function goBack() {
    history.back();
}
</script>