<div class="mobile-verify-body">
    <div class="mobile-verify-container">
        <div class="mobile-header">
            <?php $this->load->view('templates/header'); ?>
        </div>
        <h2 class="mobile-verify-title">Identity Verification via Mobile</h2>
        <div class="mobile-verify-instructions">
            <p>Scan the QR code with your mobile device to complete the verification process.</p>
            <p>Follow the instructions on your phone to upload your ID and take a selfie.</p>
        </div>
        
        <div class="mobile-qr-section">
            <div class="mobile-qr-container">
                <div class="qr-code-display" id="qrCodeContainer">
                    <!-- QR Code will be generated here by JavaScript -->
                    <div class="qr-placeholder">
                        <svg width="200" height="200" viewBox="0 0 200 200" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <rect x="0" y="0" width="25" height="25" fill="#ccc"/><rect x="25" y="0" width="25" height="25" fill="#ccc"/><rect x="50" y="0" width="25" height="25" fill="#ccc"/><rect x="75" y="0" width="25" height="25" fill="#ccc"/><rect x="100" y="0" width="25" height="25" fill="#ccc"/><rect x="125" y="0" width="25" height="25" fill="#ccc"/><rect x="150" y="0" width="25" height="25" fill="#ccc"/>
                            <rect x="0" y="25" width="25" height="25" fill="#ccc"/><rect x="50" y="25" width="25" height="25" fill="white"/><rect x="100" y="25" width="25" height="25" fill="white"/><rect x="150" y="25" width="25" height="25" fill="#ccc"/>
                            <rect x="0" y="50" width="25" height="25" fill="#ccc"/><rect x="25" y="50" width="25" height="25" fill="white"/><rect x="50" y="50" width="25" height="25" fill="white"/><rect x="75" y="50" width="25" height="25" fill="white"/><rect x="100" y="50" width="25" height="25" fill="white"/><rect x="125" y="50" width="25" height="25" fill="white"/><rect x="150" y="50" width="25" height="25" fill="#ccc"/>
                            <rect x="0" y="75" width="25" height="25" fill="#ccc"/><rect x="25" y="75" width="25" height="25" fill="white"/><rect x="50" y="75" width="25" height="25" fill="white"/><rect x="75" y="75" width="25" height="25" fill="white"/><rect x="100" y="75" width="25" height="25" fill="white"/><rect x="125" y="75" width="25" height="25" fill="white"/><rect x="150" y="75" width="25" height="25" fill="#ccc"/>
                            <rect x="0" y="100" width="25" height="25" fill="#ccc"/><rect x="25" y="100" width="25" height="25" fill="white"/><rect x="50" y="100" width="25" height="25" fill="white"/><rect x="75" y="100" width="25" height="25" fill="white"/><rect x="100" y="100" width="25" height="25" fill="white"/><rect x="125" y="100" width="25" height="25" fill="white"/><rect x="150" y="100" width="25" height="25" fill="#ccc"/>
                            <rect x="0" y="125" width="25" height="25" fill="#ccc"/><rect x="50" y="125" width="25" height="25" fill="white"/><rect x="100" y="125" width="25" height="25" fill="white"/><rect x="150" y="125" width="25" height="25" fill="#ccc"/>
                            <rect x="0" y="150" width="25" height="25" fill="#ccc"/><rect x="25" y="150" width="25" height="25" fill="#ccc"/><rect x="50" y="150" width="25" height="25" fill="#ccc"/><rect x="75" y="150" width="25" height="25" fill="#ccc"/><rect x="100" y="150" width="25" height="25" fill="#ccc"/><rect x="125" y="150" width="25" height="25" fill="#ccc"/><rect x="150" y="150" width="25" height="25" fill="#ccc"/>
                        </svg>
                    </div>
                </div>
                <p class="qr-instruction">Scan QR to continue on your phone</p>
            </div>
        </div>

        <!-- Bottom controls positioned in bottom right -->
        <div class="mobile-verify-bottom-buttons">
            <button class="mobile-verify-btn back-btn" onclick="goBack()">Back</button>
            <button id="nextButton" class="mobile-verify-btn next-btn" onclick="proceedNext()" disabled>Next</button>
        </div>

        <!-- Loading overlay for waiting -->
        <div id="mobileLoader" class="mobile-loader-overlay" style="display: none;">
            <div class="mobile-loader-content">
                <div class="mobile-spinner"></div>
                <div class="mobile-loader-text">Waiting for mobile verification...</div>
            </div>
        </div>
    </div>
</div>

<!-- Include a QR Code generation library -->
<script src="https://cdn.jsdelivr.net/npm/qrcodejs@1.0.0/qrcode.min.js"></script>

<script>
const BASE_URL = "<?php echo base_url(); ?>";
const dataParam = "<?php echo $this->input->get('data'); ?>";
const nextButton = document.getElementById('nextButton');

// Function to generate a unique session ID
function generateSessionId() {
    return 'sess_' + Date.now() + Math.random().toString(36).substr(2, 9);
}

const sessionId = generateSessionId();

// Generate QR code with a verification URL containing the session and data
function generateQRCode() {
    const verificationUrl = `${BASE_URL}mobile/start?session=${sessionId}&data=${dataParam}`;
    const qrContainer = document.getElementById('qrCodeContainer');
    qrContainer.innerHTML = ''; // Clear the placeholder
    
    new QRCode(qrContainer, {
        text: verificationUrl,
        width: 200,
        height: 200,
        colorDark : "#000000",
        colorLight : "#ffffff",
        correctLevel : QRCode.CorrectLevel.H
    });

    console.log("QR Code URL:", verificationUrl);
    
    // Start polling for verification status
    pollForVerificationStatus();
}

// Poll the server to check if mobile verification is complete
function pollForVerificationStatus() {
    const interval = setInterval(async () => {
        try {
            const response = await fetch(`${BASE_URL}api/checkMobileStatus?session=${sessionId}`);
            const result = await response.json();

            if (result.status === 'verified') {
                clearInterval(interval); // Stop polling
                console.log("Mobile verification complete!");
                nextButton.disabled = false; // Enable the Next button
                document.querySelector('.qr-instruction').textContent = '✅ Verification Complete!';
                // Optionally, automatically proceed
                // proceedNext();
            } else {
                console.log("Status:", result.status); // e.g., 'pending'
            }
        } catch (error) {
            console.error('Error polling for status:', error);
            // Consider stopping polling after several errors
        }
    }, 3000); // Check every 3 seconds
}

function goBack() {
    history.back();
}

function proceedNext() {
    if (!nextButton.disabled) {
        location.href = `<?php echo base_url('bot/attireCheck?data='); ?>${dataParam}`;
    }
}

// Initialize QR code on page load
document.addEventListener('DOMContentLoaded', function() {
    generateQRCode();
});
</script>