<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Interview Status</title>
    <style>
        body {
            background: linear-gradient(135deg, #f8fafc 0%, #e0e7ef 100%);
            min-height: 100vh;
            margin: 0;
            font-family: 'Segoe UI', Arial, sans-serif;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .center-container {
            width: 90%;
        }
        .status-message {
            display: none;
            background: #fff;
            border-radius: 18px;
            box-shadow: 0 4px 24px rgba(0,0,0,0.07);
            padding: 36px 32px 28px 32px;
            margin-bottom: 24px;
            text-align: center;
            transition: box-shadow 0.2s;
            border-top: 6px solid #4f8cff;
        }
        .status-message.active {
            display: block;
            animation: fadeIn 0.7s;
        }
        .status-message p {
            font-size: 1.15rem;
            color: #222e3a;
            margin: 0;
            line-height: 1.7;
            text-align: center;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(30px);}
            to { opacity: 1; transform: translateY(0);}
        }
        #practice-complete-message { border-top-color: #4f8cff; }
        #session-terminated-message { border-top-color: #ff6b6b; }
        #already-attempted-message { border-top-color: #f7b731; }
        #interview-complete-message { border-top-color: #2ed573; }
    </style>
</head>
<body>

    <div class="center-container">
        <?php if (isset($number) && $number == 1) { ?>
            <div id="practice-complete-message" class="status-message active">
                <p>Thanks for attending the practice interview!<br>
                You can now proceed with your scheduled interview.<br>
                If you're still unsure, give the practice session another go!</p>
            </div>
        <?php } else if (isset($number) && $number == 2) { ?>
            <div id="session-terminated-message" class="status-message active">
                <p>This interview session has been terminated due to prolonged inactivity (over 5 minutes).<br>
                If you have any feedback, please let us know.</p>
            </div>
        <?php } else if (isset($number) && $number == 3) { ?>
            <div id="already-attempted-message" class="status-message active">
                <p>You have already attempted the interview.<br>
                We appreciate your time and effort.<br>
                If you think this is a mistake, please reach out to our support.</p>
            </div>
        <?php } else if (isset($number) && $number == 4) { ?>
            <div id="interview-complete-message" class="status-message active">
                <p>
                    Thanks for attending the interview 
                    <?php echo isset($candidate_first_name) ? htmlspecialchars($candidate_first_name) : 'Candidate'; ?>!<br>
                    We appreciate your time and effort.<br>
                    If you have any feedback, please let us know.
                </p>
            </div>
        <?php } ?>
    </div>

</body>
</html>
