<?php $this->load->view('templates/header'); ?>

<script>document.body.className = 'index-page';</script>

<div id="app-container">
    <div id="intro-container">
        <!-- Left Column with Background Image -->
        <div id="intro-greetings-container">
            <div id="intro-text">
                <h3>Hello <?php echo $name; ?>,</h3>
                <h1>WELCOME TO THE AI POWERED<br>LIVE VIDEO INTERVIEW</h1>
                <h3>Duration: 30 Minutes</h3>
                <h3>Answering Language: English</h3>
                <p>Please read the instructions very carefully before proceeding.</p>
            </div>
        </div>
        
        <!-- Right Column with Instructions -->
        <div id="instructions-container">
            <div id="instructions">
                <h2>Interview Instructions:</h2>
                <ul>
                    <li>Ensure you are using a strong Wi-Fi connection and a space to focus.</li>
                    <li>Use latest version of Chrome for the best experience.</li>
                    <li>Grant access to requested permissions (Microphone, Camera).</li>
                    <li>Complete your device setup as guided and use a stable surface.</li>
                    <li>Enable pop-ups for this interview.</li>
                    <li>Verify yourself and allocate sufficient time for the interview.</li>
                    <li>Interview will be proctored, if enabled by the recruiter, and will be recorded for review purposes.</li>
                    <li>For identity verification, we may request you to upload your ID card temporarily without storing any information.</li>
                    <li>Familiarize yourself with the AI bot and then proceed.</li>
                    <li>Be comfortable and speak clearly at a moderate pace.</li>
                </ul>
                
                <form id="frmIndex" action="<?php echo base_url(); ?>bot/systemCheck?data=<?php echo $this->input->get('data'); ?>" method="post">
                    <label class="consent-label">
                        <input id="isConsent" type="checkbox" name="isConsent" value="No">
                        I agree to the 
                        <a href="https://hire.intrvuz.com/termsconditions" target="_blank">Terms of Use</a> 
                        and 
                        <a href="https://hire.intrvuz.com/privacypolicy" target="_blank">Privacy Policy</a>.
                    </label>
                    
                    <div class="intro-form-actions">
                        <button type="button" class="cancel-btn">Cancel</button>
                        <input type="submit" id="btnSubmit" class="get-started-btn" value="Get Started" disabled>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div id="alertModal" class="modal-overlay">
        <div class="modal-content">
            <div class="modal-header">
                <h3>Start Interview</h3>
            </div>
            <div class="modal-body">
                <p>Starting the interview counts as an attempt. If you exit before completing, you will lose this attempt.</p>
                <p>Do you wish to proceed?</p>
            </div>

            <?php if (isset($getSettings['vernacularResponse']) && $getSettings['vernacularResponse'] == 'on'): ?>
                <div class="language-selection-container">
                    <label for="languageSelect">Select Language:</label>
                    <select id="languageSelect" name="languageId" onchange="this.blur()">
                        <?php foreach ($languages as $lang): ?>
                            <option value="<?php echo $lang['id']; ?>"<?php if ($lang['id'] == 14) echo ' selected'; ?>><?php echo $lang['language']; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            <?php endif; ?>
            
            <div class="modal-actions">
                <button id="goBackBtn" class="cancel-btn">Cancel</button>
                <button id="proceedBtn" class="get-started-btn">Start Interview</button>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
     $('body').addClass('index-page');
    $('#isConsent').on('change', function() {
        $(this).val(this.checked ? "YES" : "NO");
        $('#btnSubmit').prop('disabled', !this.checked);
    });

    $('#btnSubmit').on('click', function(e) {
        e.preventDefault();
        if (!$('#isConsent').is(':checked')) {
            alert('You must accept the Terms of Use and Privacy Policy to proceed.');
            return false;
        }
        $('#alertModal').addClass('active');
    });

    $('#goBackBtn, .intro-form-actions .cancel-btn').on('click', function() {
        $('#alertModal').removeClass('active');
    });

    $(window).on('click', function(e) {
        if ($(e.target).hasClass('modal-overlay')) {
            $('#alertModal').removeClass('active');
        }
    });

    $('.modal-content').on('click', function(e) {
        e.stopPropagation();
    });

    $('#proceedBtn').on('click', async function() {
        var $langSelect = $('#languageSelect');
        if ($langSelect.length) {
            if (!$langSelect.val()) {
                alert('Please select a language to proceed.');
                return;
            }
            if ($('#frmIndex').find('input[name="candidateLanguageId"]').length === 0) {
                $('<input>').attr({
                    type: 'hidden',
                    name: 'candidateLanguageId',
                    value: $langSelect.val()
                }).appendTo($('#frmIndex'));
            } else {
                $('#frmIndex').find('input[name="candidateLanguageId"]').val($langSelect.val());
            }
        }
        $('#alertModal').removeClass('active');
        $('#frmIndex').submit();
    });
     $('body').addClass('index-page');
});
</script>

<?php $this->load->view('templates/footer'); ?>