<?php $this->load->view('templates/header'); ?>
<div id="app-container">
    <title>Interview</title>
   <!-- <link rel="stylesheet" href="<?php echo base_url(); ?>assets/css/mobile.css?v=<?php echo time(); ?>"> -->


    <div id="exitOverlay" class="consent-overlay" style="display:none;">
        <div class="consent-popup">
            <i class="uil uil-exclamation-octagon"></i>
            <p>You are about to exit the interview. Are you sure you want to proceed?</p>
            <button id="yesProceed" class="consent-button" style="margin-right:10px;" onclick="yesProceed(4)">Yes, Proceed</button>
            <button id="noStay" class="consent-button" onclick="noStay()">No, Stay</button>
        </div>
    </div>
	

    <div id="consentOverlay" class="consent-overlay">
        <div class="consent-popup">
            <i class="uil uil-exclamation-octagon"></i>
            <p>By proceeding, you consent to record the entire interview. Click "OK" to share your <b>current Chrome tab</b> and enable audio.</p>
            <p><b>Do not stop sharing</b> during the interview—doing so may lead to disqualification.</p>
            <button id="consentButton" class="consent-button" onclick="startInterview()">OK</button>
        </div>
    </div>

    <div id="session-indicator-container">
        <div id="media-indicator-container">
            <div class="session-indicator" title="Speaker" id="speakerIndicator"><i class="uil uil-volume-up"></i></div>
            <div class="session-indicator" title="Microphone" id="microphoneIndicator"><i class="uil uil-microphone"></i></div>
            <div class="session-indicator" title="Camera" id="cameraIndicator"><i class="uil uil-video"></i></div>
        </div>

        <div id="jd-cv-container" style="display: flex; gap: 8px;">
            <button class="user-content-button" title="Job Description" onclick="displayUserContent('JD')">
                <i class="uil uil-clipboard-notes"></i>
            </button>
            <button class="user-content-button" title="Your CV" onclick="displayUserContent('CV')">
                <i class="uil uil-file-alt"></i>
            </button>
        </div>
    </div>

    <div id="interview-wrapper">
        <div id="interview-media-container">
            <div id="video-blocks-row">
                <div id="userContainer">
                    <video id="userVideo" autoplay muted playsinline></video>
                </div>
                <canvas id="proctorCanvas" style="display:none;"></canvas>
                <div id="botContainer">
                    <video id="bot-video" poster="/assets/images/mira.png" muted></video>
                    <!-- <div id="audio-visualizer-container">
                        <canvas id="audio-visualizer"></canvas>
                    </div> -->
                </div>
            </div>
            <div id="interview-interaction-buttons">
                <!-- Timer Display -->
                <div id="answerTimer" class="timer-display" style="display: none;">02:00</div>

                <button class="control-button" id="micButton" disabled>
                   <i class="uil uil-microphone-slash"></i> | Start Answering   
                </button>
                <!-- <button class="control-button" id="end-interview-button">End Interview</button> -->
                <div class="tooltip-container">
                    <button id="end-interview-button" class="endInterviewIconBtn" onclick="endInterview()">
                        <i class="uil uil-signout"></i>
                    </button>
                    <div class="tooltip-text">End Interview</div>
                </div>
            </div>
        </div>

        <div id="conversation-container">
            <div id="conversation-container-title">Interview Conversation</div>
            <div id="conversations"></div>
        </div>
    </div>
</div>

<!-- Overlay for Job Description and CV -->
<div id="jdOverlay" class="doc-overlay">
    <div class="doc-popup">
        <span class="close-button" onclick="toggleOverlay('jdOverlay')">&times;</span>
        <h2>Job Description</h2>
        <p>Insert job description content here...</p>
    </div>
</div>

<div id="cvOverlay" class="doc-overlay">
    <div class="doc-popup">
        <span class="close-button" onclick="toggleOverlay('cvOverlay')">&times;</span>
        <h2>Your CV</h2>
        <p>Insert CV content here...</p>
    </div>
</div>


<script>
    const fullTranscript = [];
    let userAnswerRecorder;
    let userAnswerChunks = [];
    let videoChunks = [];
    let currentIndex = 0;
    let state = 'waitingForUser';
    let isRecordingAnswer = false;
    const BASE_URL = "<?php echo base_url(); ?>";
    let answerTimerInterval = null;
    const MAX_ANSWER_TIME = 120; // 120 seconds (2 minutes) for each answer


    console.log(<?php echo json_encode($questions); ?>);
    const commonId = "<?php echo $this->session->userdata('commonId'); ?>";
    console.log("Common ID:", commonId);
    // ========== Main Interview Controller ==========
    async function startInterview() {
        const userVideo = document.getElementById('userVideo');
        document.getElementById('consentOverlay').style.display = 'none';
        const stream = await navigator.mediaDevices.getUserMedia({ video: true, audio: true });
        userVideo.srcObject = stream;
        try {
            // Get mic + cam
            micCamStream = await getUserMediaStreams();
            userVideo.srcObject = micCamStream;

            // Get screen stream
            const screenStream = await getScreenStream();
            monitorScreenSharing(screenStream);

            // Optional: monitor mic input visually
            // monitorUserSpeech(micCamStream); // make sure this exists in your code

            // Merge audio tracks from mic + screen
            const mergedAudio = mergeMicScreenStreams(micCamStream, screenStream);

            // Use screen video + merged audio for recording
            const finalStream = createCombinedStream(screenStream.getVideoTracks()[0], mergedAudio);

            // Start recording in 10s chunks
            try {
                const recorder = createMediaRecorder(finalStream);
                recorder.start(6000); // 6 second chunks
                document.mediaRecorder = recorder;
            } catch (error) {
                console.error("Error occurred while starting the media recorder:", error);
            }

            // Set mic button to default "Mute"
            document.getElementById('micButton').textContent = 'Mute';
            console.log("Recording started.");
            try {
                startProctoring();
            } catch (error) {
                console.error("Error occurred while starting proctoring:", error);
            }
            try {
                questionsAndAnswers();
                
            } catch (error) {
                console.error("Error occurred while starting the interview:", error);
            }

            try{
                startTranscriptPolling();
            }catch (error) {
                console.error("Error occurred while starting transcript polling:", error);
            }

        } catch (err) {
            console.error("Interview recording failed:", err);
            alert("Failed to start interview. Please allow camera, mic, and select the current tab.");
        }
    }
// ======================================================================

    
//================== This section handles audio chunk uploads ========================
    let pendingAnswerUploads = [];

    function trackAnswerUpload(promise) {
        const trackedPromise = promise.catch(error => {
            console.error('Chunk upload failed:', error);
            // You could retry here if needed
            return Promise.reject(error);
        });
        pendingAnswerUploads.push(trackedPromise);
        return trackedPromise;
    }

    function resetAnswerUploads() {
        pendingAnswerUploads = [];
    }

    function stopAndFlushAnswerRecorder(recorder) {
        return new Promise((resolve) => {
            const onStop = async () => {
                try {
                    await new Promise(r => setTimeout(r, 0));
                    await Promise.all(pendingAnswerUploads);
                } catch (err) {
                    console.error('Error flushing uploads:', err);
                }
                resetAnswerUploads();
                recorder.removeEventListener('stop', onStop);
                resolve();
            };
            recorder.addEventListener('stop', onStop);
            recorder.stop();
        });
    }

    function startUserAnswerRecording(questionId) {
        const audioTracks = micCamStream.getAudioTracks();
        if (audioTracks.length === 0) {
            console.error("No audio track found in micCamStream");
            return;
        }
        const audioOnlyStream = new MediaStream([audioTracks[0]]);
        try {
            userAnswerRecorder = new MediaRecorder(audioOnlyStream, { mimeType: 'audio/webm' });
            
            userAnswerRecorder.ondataavailable = e => {
                if (e.data.size > 0) {
                    const fileName = `q${questionId}${commonId}.webm`;
                    // Track the upload promise
                    trackAnswerUpload(uploadAudioChunk(e.data, fileName));
                    console.log(`Uploaded audio chunk for question ${questionId}`);
                }
            };

            userAnswerRecorder.start(5000);
            console.log(`Started recording answer Q${questionId}`);
        } catch (err) {
            console.error("Error starting answer recording:", err);
        }

        startAnswerTimer();
        showAnsweringBubble();
    }

    // Function to stop recording user answers
    // function stopUserAnswerRecording() {
    //     if (userAnswerRecorder && userAnswerRecorder.state !== 'inactive') {
    //         userAnswerRecorder.stop();
    //         console.log("Stopped recording user answer");

    //         clearInterval(answerTimerInterval);
    //         document.getElementById('answerTimer').style.display = 'none';
    //         removeAnsweringBubble();
    //     }
    // }

    // NEW: Helper function to upload audio chunks as they are recorded
    async function uploadAudioChunk(chunk, filename) {
        const formData = new FormData();
        formData.append('audio_chunk', chunk);
        formData.append('filename', filename);

        try {
            const response = await fetch(`${BASE_URL}/api/appendAudioAnswer`, {
                method: 'POST',
                body: formData
            });
            const result = await response.json();
            if (result.status !== 'success') {
                throw new Error(result.message || 'Failed to upload chunk');
            }
            console.log('Audio chunk uploaded successfully for', filename);
            return result; // Explicitly return the result
        } catch (error) {
            console.error('Error uploading audio chunk:', error);
            throw error; // Re-throw to be caught by trackAnswerUpload
        }
    }
    // ======================================================================

//============ Question Retrieval from blob(PHP) and Audio Playback Functionality ==============
    function questionsAndAnswers(){
        // Initialize questions object
        const questionsraw = <?php echo json_encode($questions); ?>;
        const questions = Array.isArray(questionsraw) ? questionsraw : Object.values(questionsraw);
        try {
            // Replace mic button with a new instance to reset its state
            const micButton = document.getElementById("micButton");
            const newMicButton = micButton.cloneNode(true);
            micButton.parentNode.replaceChild(newMicButton, micButton);
            console.log("Mic button replaced successfully.");
        } catch (error) {
            console.error("Error replacing mic button:", error);
        }
        //Set new mic button
        const micButton = document.getElementById("micButton");

        //event listener for mic button
        // This listener handles the mic button click to start/stop recording user answers
        micButton.addEventListener("click",async () => {
            console.log(`Current state: ${state}, isRecordingAnswer: ${isRecordingAnswer}`);
            // Check if we are waiting for user input
            // only goes forward if the bot is done speaking and we are ready for recording the user's answer
            if (state !== 'waitingForUser') return;
            // If we are waiting for user input, toggle recording state
            if (!isRecordingAnswer) {
                // Start recording now
                isRecordingAnswer = true;
                // Set mic button to indicate recording
                micButton.innerHTML = `<i class="uil uil-microphone-slash"></i> | Stop Answering`;
                document.getElementById("microphoneIndicator").innerHTML = `<i class="uil uil-microphone-slash"></i>`;
                console.log(`Recording Started`);
                startUserAnswerRecording(questions[currentIndex].id);
            } else {
                // Stop recording and go to next question
                isRecordingAnswer = false;
                console.log(`Stopping & flushing final audio chunk...`);
                await stopAndFlushAnswerRecorder(userAnswerRecorder);
                console.log(`All audio chunks uploaded.`);

                // Update UI
                clearInterval(answerTimerInterval);
                document.getElementById('answerTimer').style.display = 'none';
                removeAnsweringBubble();

                const fileName = `q${questions[currentIndex].id}${commonId}.webm`;
                const question = questions[currentIndex].question;
                
                // Now safe to request transcription
                fetch(`${BASE_URL}/api/transcribeAudio`, {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({
                        fileName: fileName,
                        question: question
                    })
                }).then(res => res.json())
                  .then(data => console.log('Transcription request sent:', data));

                //Increment the current index to move to the next question
                currentIndex++;

                if (currentIndex >= questions.length) {
                    console.log("Interview complete.");
                    micButton.disabled = true;
                    micButton.innerHTML = `<i class="uil uil-microphone-slash"></i> | Interview Complete`;
                    document.getElementById("microphoneIndicator").innerHTML = `<i class="uil uil-microphone-slash"></i>`;
                    return;
                }

                state = 'waitingForBot';
                playBotQuestion(questions, currentIndex);
            }
        });

        // Start first question
        playBotQuestion(questions, currentIndex);
    }
// ======================================================================


// =============== Bot Asking Question Function ===============
    // Function to play the bot's question
    // This function plays the bot's question audio and waits for the user to respond
    function playBotQuestion(questions, index) {
        // Check if we have reached the end of the questions
        if (index >= questions.length) {
            console.log("Interview complete.");
            document.getElementById("micButton").disabled = true;
            document.getElementById("micButton").innerHTML = `<i class="uil uil-microphone-slash"></i> | Interview Complete`;
            document.getElementById("microphoneIndicator").innerHTML = `<i class="uil uil-microphone-slash"></i>`;
            return;
        }

        //Play the bot's question audio
        const q = questions[index];
        const audio = new Audio(q.audioUrl);
        console.log(`Bot is asking: ${q.question}`);
        //Mic Set to disabled
        document.getElementById("micButton").disabled = true;
        document.getElementById("micButton").innerHTML = `<i class="uil uil-microphone-slash"></i> | Start Answering`;
        document.getElementById("microphoneIndicator").innerHTML = `<i class="uil uil-microphone-slash"></i>`;
        time = new Date().toISOString();
        const questionData = {
            questionId: q.id,
            timestamp: time,
            bot: q.question,
            user: "...", // Placeholder for the user's answer
            duration: null
        };
        fetch(`${BASE_URL}/api/saveTranscript`, {
            method: 'POST',
            headers: {'Content-Type': 'application/json'},
            body: JSON.stringify({ commonId: commonId, questionData: questionData })
        });

        //Bot set to active speaker
        setBotSpeaking();
        // Append the bot's question to the live transcript

        // Start visualization
        // if (typeof connectBotAudioVisualizerFromUrl === 'function') {
        //     connectBotAudioVisualizerFromUrl(q.audioUrl);
        // } else {
        //     console.warn("Visualizer function not found");
        // }


        // Start playing the audio
        audio.play();

        // Set the state to waiting for user response after the bot finishes speaking
        audio.onended = () => {
            console.log(`Bot finished speaking question ${index + 1}`);
            state = 'waitingForUser';
            // Enable mic button for user to start answering
            document.getElementById("micButton").disabled = false;
            document.getElementById("micButton").innerHTML = `<i class="uil uil-microphone"></i> | Start Answering`;
            document.getElementById("microphoneIndicator").innerHTML = `<i class="uil uil-microphone"></i>`;
            // Set user as the active speaker
            setUserSpeaking();
        };

        // Handle audio playback errors
        audio.onerror = (e) => {
            console.error("Audio playback error:", e);
            state = 'waitingForUser';
            document.getElementById("micButton").disabled = false;
            document.getElementById("micButton").innerHTML = `<i class="uil uil-microphone"></i> | Start Answering`;
            document.getElementById("microphoneIndicator").innerHTML = `<i class="uil uil-microphone"></i>`;
        };
    }

// ======================================================================
// ========== Live Transcript Polling and Rendering ====================

    function startTranscriptPolling() {
        transcriptPollInterval = setInterval(() => {
            fetch(`${BASE_URL}/api/getTranscript/${commonId}`)
                .then(response => {
                    if (response.ok) {
                        return response.json();
                    }
                    throw new Error('Network response was not ok.');
                })
                .then(transcriptData => {
                    renderTranscript(transcriptData);
                })
                .catch(error => {
                    console.error('Error fetching transcript:', error);
                });
        }, 3000); // Poll every 3 seconds
    }

    function renderTranscript(transcript) {
        const conversationsDiv = document.getElementById("conversations");
        conversationsDiv.innerHTML = ''; // Clear the current view

        transcript.forEach(entry => {
            // Add the bot's message
            const botMessage = document.createElement("div");
            botMessage.className = 'botMessage';
            botMessage.innerText = `${entry.bot}`;
            conversationsDiv.appendChild(botMessage);

            // Add the user's message if it exists and is not the placeholder
            if (entry.user && entry.user !== "...") {
                const userMessage = document.createElement("div");
                userMessage.className = 'userMessage';
                userMessage.innerText = `${entry.user}`;
                conversationsDiv.appendChild(userMessage);
            }
        });


        if (isRecordingAnswer) {
            showAnsweringBubble();
        }
        // Auto-scroll to the bottom
        conversationsDiv.scrollTop = conversationsDiv.scrollHeight;
    }
// ==================== Active/ Passive Speaker Functions ====================
    // Function to set bot as the active speaker
    // This function is called when the bot starts speaking
    function setBotSpeaking() {
        document.getElementById("userContainer").classList.remove("activeSpeaker");
        document.getElementById("userContainer").classList.add("passiveSpeaker");
        document.getElementById("botContainer").classList.remove("passiveSpeaker");
        document.getElementById("botContainer").classList.add("activeSpeaker");
    }

    // Function to set user as the active speaker
    // This function is called when the user starts speaking
    function setUserSpeaking() {
        document.getElementById("userContainer").classList.add("activeSpeaker");
        document.getElementById("userContainer").classList.remove("passiveSpeaker");
        document.getElementById("botContainer").classList.add("passiveSpeaker");
        document.getElementById("botContainer").classList.remove("activeSpeaker");
    }
// ======================================================================

// ==================== Tab Sharing Functions ====================
    // Get screen stream with enforced tab sharing
    // This function requests the user to share their current browser tab only
    async function getScreenStream() {
        const displayMediaOptions = {
            video: {
                displaySurface: "browser",
                cursor: "always"
            },
            audio: {
                echoCancellation: true,
                noiseSuppression: true
            },
            preferCurrentTab: true
        };

        const screenStream = await navigator.mediaDevices.getDisplayMedia(displayMediaOptions);

        // Enforce current tab only
        const settings = screenStream.getVideoTracks()[0].getSettings();
        if (settings.displaySurface !== 'browser') {
            screenStream.getTracks().forEach(track => track.stop());
            alert("Please share only your current browser tab.");
            throw new Error("Invalid displaySurface. Only tab sharing is allowed.");
        }
        return screenStream;
    }


    let micCamStream;

// ==================== End Interview Button ====================
    document.getElementById('end-interview-button').addEventListener('click', () => {
        clearInterval(transcriptPollInterval);
        if (document.mediaRecorder && document.mediaRecorder.state !== "inactive") {
            document.mediaRecorder.stop(); // This triggers the upload
        }
        endInterview();
    });
// ======================================================================

// ========== User Content (JD/CV) Overlay Display Functions ==========
    function displayUserContent(type) {
        if (type === 'JD') {
            toggleOverlay('jdOverlay');
        } else if (type === 'CV') {
            toggleOverlay('cvOverlay');
        }
    }

    function toggleOverlay(id) {
        const overlay = document.getElementById(id);
        const popup = overlay.querySelector('.doc-popup');

        const isVisible = overlay.style.display === 'flex';

        if (isVisible) {
            // Start fade-out animations
            popup.style.animation = 'foldPopup 0.3s ease forwards';
            overlay.style.animation = 'fadeOutOverlay 0.3s ease forwards';

            // Wait for animation to finish, then hide
            setTimeout(() => {
                overlay.style.display = 'none';
            }, 300);

            document.removeEventListener('mousedown', overlayClickHandler);
        } else {
            // Show and play open animation
            overlay.style.display = 'flex';

            popup.style.animation = 'none';
            overlay.style.animation = 'none';
            void popup.offsetWidth;
            void overlay.offsetWidth;

            popup.style.animation = 'unfoldPopup 0.4s ease forwards';
            overlay.style.animation = 'fadeInOverlay 0.3s ease forwards';

            document.addEventListener('mousedown', overlayClickHandler);
        }
    }

    // Click handler for overlay to close when clicking outside the popup
    function overlayClickHandler(event) {
        document.querySelectorAll('.doc-overlay').forEach(overlay => {
            const popup = overlay.querySelector('.doc-popup');
            if (overlay.style.display === 'flex' && !popup.contains(event.target)) {
                toggleOverlay(overlay.id); 
            }
        });
    }

    // Add event listener for clicking Escape key to close overlays
    document.addEventListener('keydown', function (e) {
        if (e.key === 'Escape') {
            document.querySelectorAll('.doc-overlay').forEach(overlay => {
                overlay.style.display = 'none';
            });
            document.removeEventListener('mousedown', overlayClickHandler);
        }
    });
// ======================================================================

// ========== End Button Functionality ==========

    ///////////// End button functionality./////////////
    function endInterview(){
        $("#exitOverlay").show();
    }

    function yesProceed(number) {
        // Proceed with exit (e.g., redirect or cleanup)
        const redirectUrl = `${BASE_URL}bot/exit/${number}`;
        window.location.href = redirectUrl;
        console.log(`Exiting interview with redirect to: ${redirectUrl}`);
    }
    function noStay() {
        $("#exitOverlay").hide(); // Change to your desired exit action
    }
// ======================================================================

// ======================New Helper Function For timer===================
    function startAnswerTimer() {
        let timeLeft = MAX_ANSWER_TIME;
        const timerDisplay = document.getElementById('answerTimer');
        timerDisplay.style.display = 'block';
        timerDisplay.textContent = formatTime(timeLeft);

        answerTimerInterval = setInterval(() => {
            timeLeft--;
            timerDisplay.textContent = formatTime(timeLeft);
            if (timeLeft <= 0) {
                console.log("Time is up. Automatically stopping recording.");
                document.getElementById('micButton').click();
            }
        }, 1000);
    }

    function formatTime(seconds) {
        const minutes = Math.floor(seconds / 60);
        const remainingSeconds = seconds % 60;
        return `${minutes}:${remainingSeconds < 10 ? '0' : ''}${remainingSeconds}`;
    }

    function showAnsweringBubble() {
        const conversationsDiv = document.getElementById("conversations");
        const answeringBubble = document.createElement("div");
        answeringBubble.className = 'userMessage answering';
        answeringBubble.innerHTML = `<span>.</span><span>.</span><span>.</span>`;
        conversationsDiv.appendChild(answeringBubble);
        conversationsDiv.scrollTop = conversationsDiv.scrollHeight;
    }

    function removeAnsweringBubble() {
        const answeringBubble = document.querySelector('.userMessage.answering');
        if (answeringBubble) {
            answeringBubble.remove();
        }
    }
</script>

<script src="<?php echo base_url(); ?>assets/js/proctor.js?v=<?php echo time(); ?>"></script>
<script src="<?php echo base_url(); ?>assets/js/videoSave.js?v=<?php echo time(); ?>"></script>
<!-- <script src="<?php echo base_url(); ?>assets/js/mobile_interview.js?v=<?php echo time(); ?>"></script> -->
