<?php $this->load->view('templates/header'); ?>
<div id="app-container">
    <title>Interview</title>
   <!-- <link rel="stylesheet" href="<?php echo base_url(); ?>assets/css/mobile.css?v=<?php echo time(); ?>"> -->


    <div id="exitOverlay" class="consent-overlay" style="display:none;">
        <div class="consent-popup">
            <i class="uil uil-exclamation-octagon"></i>
            <p>You are about to exit the interview. Are you sure you want to proceed?</p>
            <button id="yesProceed" class="consent-button" style="margin-right:10px;" onclick="yesProceed(4)">Yes, Proceed</button>
            <button id="noStay" class="consent-button" onclick="noStay()">No, Stay</button>
        </div>
    </div>
	

    <div id="consentOverlay" class="consent-overlay">
        <div class="consent-popup">
            <i class="uil uil-exclamation-octagon"></i>
            <p>By proceeding, you consent to record the entire interview. Click "OK" to share your <b>current Chrome tab</b> and enable audio.</p>
            <p><b>Do not stop sharing</b> during the interview—doing so may lead to disqualification.</p>
            <button id="consentButton" class="consent-button" onclick="startInterview()">OK</button>
        </div>
    </div>

    <div id="session-indicator-container">
        <div id="media-indicator-container">
            <div class="session-indicator" title="Speaker" id="speakerIndicator"><i class="uil uil-volume-up"></i></div>
            <div class="session-indicator" title="Microphone" id="microphoneIndicator"><i class="uil uil-microphone"></i></div>
            <div class="session-indicator" title="Camera" id="cameraIndicator"><i class="uil uil-video"></i></div>
        </div>

        <div id="jd-cv-container" style="display: flex; gap: 8px;">
            <button class="user-content-button" title="Job Description" onclick="displayUserContent('JD')">
                <i class="uil uil-clipboard-notes"></i>
            </button>
            <button class="user-content-button" title="Your CV" onclick="displayUserContent('CV')">
                <i class="uil uil-file-alt"></i>
            </button>
        </div>
    </div>

    <div id="interview-wrapper">
        <div id="interview-media-container">
            <div id="video-blocks-row">
                <div id="userContainer">
                    <video id="userVideo" autoplay muted playsinline></video>
                </div>
                <canvas id="proctorCanvas" style="display:none;"></canvas>
                <div id="botContainer">
                    <video id="bot-video" poster="/assets/images/mira.png" muted></video>
                    <!-- <div id="audio-visualizer-container">
                        <canvas id="audio-visualizer"></canvas>
                    </div> -->
                </div>
            </div>
            <div id="interview-interaction-buttons">

                <!-- <button class="control-button" id="micButton" disabled>
                   <i class="uil uil-microphone-slash"></i> | Start Answering   
                </button> -->
                <div class="tooltip-container">
                    <button id="end-interview-button" class="endInterviewIconBtn">
                        <i class="uil uil-signout"></i>
                    </button>
                    <div class="tooltip-text">End Interview</div>
                </div>
                <!-- <button class="control-button" id="micButton" disabled>
                   <i class="uil uil-microphone-slash"></i> | Start Answering   
                </button>
                <button class="control-button" id="end-interview-button">End Interview</button> -->


            </div>
        </div>

        <div id="conversation-container">
            <div id="conversation-container-title">Interview Conversation</div>
            <div id="conversations"></div>
        </div>
    </div>
</div>

<!-- Overlay for Job Description and CV -->
<div id="jdOverlay" class="doc-overlay">
    <div class="doc-popup">
        <span class="close-button" onclick="toggleOverlay('jdOverlay')">&times;</span>
        <h2>Job Description</h2>
        <p>Insert job description content here...</p>
    </div>
</div>

<div id="cvOverlay" class="doc-overlay">
    <div class="doc-popup">
        <span class="close-button" onclick="toggleOverlay('cvOverlay')">&times;</span>
        <h2>Your CV</h2>
        <p>Insert CV content here...</p>
    </div>
</div>

<script>
    const fullTranscript = [];
    let userAnswerRecorder;
    let userAnswerChunks = [];
    let videoChunks = [];
    let currentIndex = 0;
    let state = 'waitingForUser';
    let isRecordingAnswer = false;
    const BASE_URL = "<?php echo base_url(); ?>";
    const commonId = "<?php echo $this->session->userdata('commonId'); ?>";
    console.log("Common ID:", commonId);
    // ========== Main Interview Controller ==========
    async function startInterview() {
        const userVideo = document.getElementById('userVideo');
        document.getElementById('consentOverlay').style.display = 'none';
        
        try {
            // Get mic + cam
            micCamStream = await getUserMediaStreams();
            userVideo.srcObject = micCamStream;

            // Get screen stream
            const screenStream = await getScreenStream();
            monitorScreenSharing(screenStream);

            screenStream.getAudioTracks().forEach(track => {
                console.log('Screen audio track:', track.getSettings());
            });
            // Optional: monitor mic input visually
            // monitorUserSpeech(micCamStream); // make sure this exists in your code

            // Merge audio tracks from mic + screen
            const mergedAudio = mergeMicScreenStreams(micCamStream, screenStream);

            // Use screen video + merged audio for recording
            const finalStream = createCombinedStream(screenStream.getVideoTracks()[0], mergedAudio);

            // Start recording in 10s chunks
            try {
                const recorder = createMediaRecorder(finalStream);
                recorder.start(6000); // 5 second chunks
                document.mediaRecorder = recorder;
            } catch (error) {
                console.error("Error occurred while starting the media recorder:", error);
            }
            console.log("Recording started.");
            try {
                startProctoring();
            } catch (error) {
                console.error("Error occurred while starting proctoring:", error);
            }
            try {
                questionsAndAnswers();
            } catch (error) {
                console.error("Error occurred while starting the interview:", error);
            }


        } catch (err) {
            console.error("Interview recording failed:", err);
            alert("Failed to start interview. Please allow camera, mic, and select the current tab.");
        }
    }


// ==================== Tab Sharing Functions ============================
    // Get screen stream with enforced tab sharing
    // This function requests the user to share their current browser tab only
    async function getScreenStream() {
        const displayMediaOptions = {
            video: {
                displaySurface: "browser",
                cursor: "always"
            },
            // audio: {
            //     echoCancellation: true,
            //     noiseSuppression: true
            // },
            audio: true,
            preferCurrentTab: true
        };

        const screenStream = await navigator.mediaDevices.getDisplayMedia(displayMediaOptions);

        // Enforce current tab only
        const settings = screenStream.getVideoTracks()[0].getSettings();
        if (settings.displaySurface !== 'browser') {
            screenStream.getTracks().forEach(track => track.stop());
            alert("Please share only your current browser tab.");
            throw new Error("Invalid displaySurface. Only tab sharing is allowed.");
        }
        return screenStream;
    }
// ========== Live Transcript and Conversation Handling ==========
    let micCamStream;

    // Append live transcript to the conversation container
    // function appendLiveTranscript(role, text) {
    //     const conversationsDiv = document.getElementById("conversations");
    //     const messageDiv = document.createElement("div");

    //     messageDiv.className = role === 'bot' ? 'botMessage' : 'userMessage';
    //     messageDiv.innerText = `${role === 'bot' ? 'Bot' : 'You'}: ${text}`;

    //     conversationsDiv.appendChild(messageDiv);
    //     conversationsDiv.scrollTop = conversationsDiv.scrollHeight;
    // }

    // // Save the full transcript to the server
    // function sendTranscriptToServer() {
    //     fetch('/api/saveTranscript', {
    //         method: 'POST',
    //         headers: {
    //             'Content-Type': 'application/json'
    //         },
    //         body: JSON.stringify({
    //             transcript: fullTranscript,
    //             filename: `chat${commonId}.json` 
    //         })
    //     })
    //     .then(res => res.json())
    //     .then(data => {
    //         console.log('Transcript chunk saved:', data);
    //     })
    //     .catch(err => {
    //         console.error('Transcript save failed:', err);
    //     });
    // }
// ==============================================================

// ==================== End Interview Button ====================
    document.getElementById('end-interview-button').addEventListener('click', () => {
       // clearInterval(transcriptPollInterval);
        if (document.mediaRecorder && document.mediaRecorder.state !== "inactive") {
            document.mediaRecorder.stop(); // This triggers the upload
        }
        endInterview();
    });
// ======================================================================

// ========== User Content (JD/CV) Overlay Display Functions ==========
    function displayUserContent(type) {
        if (type === 'JD') {
            toggleOverlay('jdOverlay');
        } else if (type === 'CV') {
            toggleOverlay('cvOverlay');
        }
    }

    function toggleOverlay(id) {
        const overlay = document.getElementById(id);
        const popup = overlay.querySelector('.doc-popup');

        const isVisible = overlay.style.display === 'flex';

        if (isVisible) {
            // Start fade-out animations
            popup.style.animation = 'foldPopup 0.3s ease forwards';
            overlay.style.animation = 'fadeOutOverlay 0.3s ease forwards';

            // Wait for animation to finish, then hide
            setTimeout(() => {
                overlay.style.display = 'none';
            }, 300);

            document.removeEventListener('mousedown', overlayClickHandler);
        } else {
            // Show and play open animation
            overlay.style.display = 'flex';

            popup.style.animation = 'none';
            overlay.style.animation = 'none';
            void popup.offsetWidth;
            void overlay.offsetWidth;

            popup.style.animation = 'unfoldPopup 0.4s ease forwards';
            overlay.style.animation = 'fadeInOverlay 0.3s ease forwards';

            document.addEventListener('mousedown', overlayClickHandler);
        }
    }

    // Click handler for overlay to close when clicking outside the popup
    function overlayClickHandler(event) {
        document.querySelectorAll('.doc-overlay').forEach(overlay => {
            const popup = overlay.querySelector('.doc-popup');
            if (overlay.style.display === 'flex' && !popup.contains(event.target)) {
                toggleOverlay(overlay.id); 
            }
        });
    }

    // Add event listener for clicking Escape key to close overlays
    document.addEventListener('keydown', function (e) {
        if (e.key === 'Escape') {
            document.querySelectorAll('.doc-overlay').forEach(overlay => {
                overlay.style.display = 'none';
            });
            document.removeEventListener('mousedown', overlayClickHandler);
        }
    });
// ======================================================================

// ========== End Button Functionality ==========

    ///////////// End button functionality./////////////
    function endInterview(){
        $("#exitOverlay").show();
    }

    function yesProceed(number) {
        // Proceed with exit (e.g., redirect or cleanup)
        const redirectUrl = `${BASE_URL}bot/exit/${number}`;
        window.location.href = redirectUrl;
        console.log(`Exiting interview with redirect to: ${redirectUrl}`);
    }
    function noStay() {
        $("#exitOverlay").hide(); // Change to your desired exit action
    }
// ======================================================================
</script>

<script src="<?php echo base_url(); ?>assets/js/retell-client.umd.js?v=<?php echo time(); ?>"></script>
<script src="<?php echo base_url(); ?>assets/js/interview_ai.js?v=<?php echo time(); ?>"></script>

<script src="<?php echo base_url(); ?>assets/js/proctor.js?v=<?php echo time(); ?>"></script>
<script src="<?php echo base_url(); ?>assets/js/videoSave.js?v=<?php echo time(); ?>"></script>
<!-- <script src="<?php echo base_url(); ?>assets/js/mobile_interview.js?v=<?php echo time(); ?>"></script> -->
