<?php $this->load->view('templates/header'); ?>

<div class="loader-container">
    <div class="loader"></div>
    <div class="prepare-message">
        Your interview is being prepared...
        <div id="progress-text" style="margin-top:10px;font-size:1.2em;">0%</div>
    </div>
</div>

<script>
    function updateProgress(percent) {
        $('#progress-text').text(percent + '%');
    }

    $(document).ready(function() {
        // Start with 0%
        updateProgress(0);

        // Start AJAX polling to get progress
        function pollProgress() {
            $.ajax({
                url: "<?php echo  base_url('bot/ajaxPrepare?data=' . $this->input->get('data')) ?>",
                type: "POST",
                dataType: "json",
                success: function(response) {
                    if(response && typeof response.percent !== "undefined") {
                        //console.log(response.percent);
                        updateProgress(response.percent);
                    }
                    if(response && response.redirect) {
                        window.location.href = response.redirect;
                    } else {
                        // Continue polling until complete
                        setTimeout(pollProgress, 700);
                    }
                },
                error: function() {
                    // Optionally handle error
                    setTimeout(pollProgress, 1500);
                }
            });
        }
        pollProgress();
    });
</script>