
                <?php $this->load->view('templates/header'); ?>

<!-- The main wrapper that provides space for the fixed header -->
<div id="app-container">

    <!-- This is the main white, centered panel -->
    <div id="system-check-page">
        <div id="syscheck-content">
            <!-- Left side - Camera Preview -->

            <div id="syscheck-camera-preview-container">
                <video id="cameraPreview" autoplay muted playsinline></video>
                <div class="syscheck-camera-selector">
                    <div class="sys-header">
                        <h3>Cameras</h3>
                        <div id="cameraStatus" class="status-indicator hidden">
                            <span class="dot"></span> Working
                        </div>
                    </div>
                    <div class="device-row">
                        <select id="cameraSelect"></select>
                    </div>
                </div>
            </div>

            <!-- Right side - Device Controls -->
            <div id="syscheck-controls-container">
                <div id="syscheck-microphones">
                    <div class="sys-header">
                        <h3>Microphones</h3>
                        <div id="micStatus" class="status-indicator hidden">
                            <span class="dot"></span> Working
                        </div>
                    </div>                   
                    <div class="device-row">
                        <select id="micSelect"></select>
                    </div>
                    <div id="micActivity">
                        <?php for ($i = 0; $i < 12; $i++): ?><div class="pid"></div><?php endfor; ?>
                    </div>
                </div>

                <div id="syscheck-speakers">
                    <div class="sys-header">
                        <h3>Speakers</h3>
                        <div id="speakerStatus" class="status-indicator hidden">
                            <span class="dot"></span> Working
                        </div>
                    </div>
                    <div class="sys-header">
                        <select id="speakerSelect"></select>
                        <button class="test-speaker-btn" onclick="testSpeaker()">🔊 Test </button>
                    </div>
                    <audio id="testAudio" src="<?= base_url() ?>/assets/test-sound.mp3"></audio>
                </div>

                <div id="syscheck-network">
                    <h3>Internet Bandwidth</h3>
                    <div class="device-row">
                        <div id="network-bars">
                            <?php for ($i = 0; $i < 8; $i++): ?><div class="network-bar"></div><?php endfor; ?>
                        </div>
                        <div id="progress" class="status-indicator">
                            <!-- JS will update this -->
                        </div>
                    </div>
                </div>
                <div class="syscheck-bottom-section">
                    <p class="center-al-text">If everything appears to be in order, please select the 'Continue' button below. Otherwise, adjust your device settings or choose another device.</p>
                    <div class="syscheck-bottom-buttons">
                        <button type="button" class="back-btn" onclick="goBack()">Back</button>
                        <form action="<?php echo base_url('bot/redirectToPage/systemCheck?data=' . $this->input->get('data')) ?>" method="post" class="no-mb">
                            <input type="submit" class="get-started-btn" value="Continue">
                        </form>
                    </div>
                </div>                
            </div>
        </div>

        <!-- Bottom instruction and buttons section -->

    </div>
</div>

<audio id="testAudio" src="<?= base_url() ?>/assets/test-sound.mp3"></audio>

<script>
    let audioContext, analyser, micStream;

    function goBack() { window.history.back(); }

    async function enumerateDevices() {
        await navigator.mediaDevices.getUserMedia({ audio: true, video: true }); // Request permissions first to get labels
        const devices = await navigator.mediaDevices.enumerateDevices();
        
        const micSelect = document.getElementById('micSelect');
        const camSelect = document.getElementById('cameraSelect');
        const speakerSelect = document.getElementById('speakerSelect');
        
        micSelect.innerHTML = ''; camSelect.innerHTML = ''; speakerSelect.innerHTML = '';

        devices.forEach(device => {
            const option = document.createElement('option');
            option.value = device.deviceId;
            option.text = device.label || `${device.kind} ${micSelect.options.length + 1}`;
            if (device.kind === 'audioinput') micSelect.appendChild(option);
            else if (device.kind === 'videoinput') camSelect.appendChild(option);
            else if (device.kind === 'audiooutput') speakerSelect.appendChild(option);
        });
    }

    async function startCameraPreview(deviceId = null) {
        if (document.getElementById('cameraPreview').srcObject) {
            document.getElementById('cameraPreview').srcObject.getTracks().forEach(track => track.stop());
        }
        const constraints = { video: deviceId ? { deviceId: { exact: deviceId } } : true };
        const stream = await navigator.mediaDevices.getUserMedia(constraints);
        document.getElementById('cameraPreview').srcObject = stream;
        document.getElementById('cameraStatus').classList.remove('hidden');
    }

    async function startMicAnalyzer(deviceId = null) {
        if (micStream) micStream.getTracks().forEach(track => track.stop());
        const constraints = { audio: deviceId ? { deviceId: { exact: deviceId } } : true };
        micStream = await navigator.mediaDevices.getUserMedia(constraints);
        audioContext = new (window.AudioContext || window.webkitAudioContext)();
        const source = audioContext.createMediaStreamSource(micStream);
        analyser = audioContext.createAnalyser();
        analyser.fftSize = 32;
        const dataArray = new Uint8Array(analyser.frequencyBinCount);
        source.connect(analyser);

        function draw() {
            requestAnimationFrame(draw);
            analyser.getByteFrequencyData(dataArray);
            const bars = document.querySelectorAll("#micActivity .pid");
            bars.forEach((bar, i) => {
                const intensity = dataArray[i] / 255.0; // Normalize to 0-1
                bar.style.opacity = intensity;
            });
        }
        draw();
        document.getElementById('micStatus').classList.remove('hidden');
    }


    document.getElementById('cameraSelect').addEventListener('change', (e) => startCameraPreview(e.target.value));
    document.getElementById('micSelect').addEventListener('change', (e) => startMicAnalyzer(e.target.value));

    function updateNetworkUI(speedMbps) {
        const bars = document.querySelectorAll('.network-bar');
        const progress = document.getElementById('progress');
        let activeBars = 0;
        let statusText = 'Low';
        let statusColor = '#fee2e2';
        let dotColor = '#dc2626';
        let textColor = '#991b1b';

        if (speedMbps > 25) { activeBars = 8; statusText = 'Excellent'; statusColor='#dcfce7'; dotColor='#22c55e'; textColor='#166534'; }
        else if (speedMbps > 10) { activeBars = 6; statusText = 'Good'; statusColor='#dcfce7'; dotColor='#22c55e'; textColor='#166534'; }
        else if (speedMbps > 4) { activeBars = 4; statusText = 'Average'; statusColor='#fef3c7'; dotColor='#f59e0b'; textColor='#92400e';}
        else if (speedMbps > 0) { activeBars = 2; statusText = 'Poor'; }
        
        bars.forEach((bar, index) => bar.classList.toggle('active', index < activeBars));
        progress.innerHTML = `<span class="dot"></span> ${statusText}`;
        progress.style.backgroundColor = statusColor;
        progress.style.color = textColor;
        progress.querySelector('.dot').style.backgroundColor = dotColor;
    }

    function testSpeaker() {
        const audio = document.getElementById('testAudio');
        audio.play();
        audio.onplay = () => {
            document.getElementById('speakerStatus').classList.remove('hidden');
        };
    }


    function MeasureConnectionSpeed() {
        const imageAddr = "https://media.geeksforgeeks.org/wp-content/cdn-uploads/20200714180638/CIP_Launch-banner.png";
        let time_start, end_time;
        let downloadSize = 5616998;
        const download = new Image();
        download.onload = () => {
            end_time = (new Date()).getTime();
            let timeDuration = (end_time - time_start) / 1000;
            let loadedBits = downloadSize;
            let bps = (loadedBits / timeDuration).toFixed(2);
            let speedInKbps = (bps / 1024).toFixed(2);
            let speedInMbps = (speedInKbps / 1024).toFixed(2);
            updateNetworkUI(speedInMbps);
            // alert(`Your connection speed is ${speedInMbps} Mbps`);
        };
        download.onerror = () => alert("Error loading image");
        time_start = (new Date()).getTime();
        download.src = imageAddr;
    }

    (async () => {
        try {
            await enumerateDevices();
            await startCameraPreview();
            await startMicAnalyzer();
            MeasureConnectionSpeed();
        } catch (err) {
            alert("Please allow mic and camera access to proceed.");
            console.error("Permission error", err);
        }
    })();
</script>

<?php $this->load->view('templates/footer'); ?>