<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Attire Status</title>
    <style>
        body {
            background: linear-gradient(135deg, #f8fafc 0%, #e0e7ef 100%);
            min-height: 100vh;
            margin: 0;
            font-family: 'Segoe UI', Arial, sans-serif;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .center-container {
            width: 90%;
            max-width: 600px;
        }
        .status-message.active {
            display: flex;
            align-items: center;
            animation: fadeIn 0.7s;
        }
        .status-message img {
            width: 50px;
            height: 50px;
            margin-right: 20px;
            border-radius: 50%;
        }
        .status-message p {
            font-size: 1.15rem;
            color: #222e3a;
            margin: 0;
            line-height: 1.7;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(30px);}
            to { opacity: 1; transform: translateY(0);}
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            background-color: #fff;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: 0 2px 12px rgba(0,0,0,0.05);
        }
        th, td {
            padding: 12px 16px;
            text-align: left;
            border-bottom: 1px solid #f0f0f0;
        }
        th {
            background-color: #f1f5f9;
            font-weight: bold;
            color: #334155;
            width: 40%;
        }

        /* Print Button Style */
        .print-button {
            margin: 20px 0;
            padding: 10px 20px;
            background-color: #4f8cff;
            color: white;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 16px;
        }

        /* Hide print button during print */
        @media print {
            .print-button {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="center-container" id="print-area">
        <div id="practice-complete-message">
            <img src="<?php echo $imgUrl; ?>" alt="Status Icon" width="200px;" height="200px;">
        </div>

        <!-- Print Button -->
        <button class="print-button" onclick="printSection('print-area')">🖨️ Print</button>

        <table>
            <tbody>
                <tr>
                    <th>Confidence</th>
                    <td><?php echo $jsonContent['confidence']; ?></td>
                </tr>
                <tr>
                    <th>Dress Code</th>
                    <td><?php echo $jsonContent['dress_code']; ?></td>
                </tr>
                <tr>
                    <th>Formal Score</th>
                    <td><?php echo $jsonContent['formal_score']; ?></td>
                </tr>
                <tr>
                    <th>Informal Score</th>
                    <td><?php echo $jsonContent['informal_score']; ?></td>
                </tr>
                <tr>
                    <th>Reason</th>
                    <td><?php echo $jsonContent['reason']; ?></td>
                </tr>
                <tr>
                    <th>Phone No</th>
                    <td><?php echo $jsonContent['phone_number']; ?></td>
                </tr>
            </tbody>
        </table>
    </div>

    <script>
        function printSection(divId) {
            const content = document.getElementById(divId).innerHTML;
            const printWindow = window.open('', '', 'height=700,width=900');
            printWindow.document.write('<html><head><title>Print</title>');
            printWindow.document.write('<style>body{font-family:sans-serif} table{width:100%;border-collapse:collapse;} th,td{padding:10px;border:1px solid #ccc;} th{background:#f1f5f9;}</style>');
            printWindow.document.write('</head><body>');
            printWindow.document.write(content);
            printWindow.document.write('</body></html>');
            printWindow.document.close();
            printWindow.focus();
            printWindow.print();
            printWindow.close();
        }
    </script>
</body>
</html>
