<?php $this->load->view('templates/header'); ?>

    
    <div class="center-container" id="print-area">

        <!-- Print Button -->
        <button class="print-button" onclick="printSection('print-area')">🖨️ Print</button>

        <table>
            <tbody>
                <tr>
                    <th>Start Time</th>
                    <td><?php echo date('Y-m-d H:i:s', (int) ($start_timestamp/1000)); ?></td>
                </tr>
                <tr>
                    <th>End Time</th>
                    <td><?php echo date('Y-m-d H:i:s', (int) ($end_timestamp/1000)); ?></td>
                </tr>
                <tr>
                    <th>Duration (in seconds)</th>
                    <td><?php echo floor($duration_ms/1000); ?></td>
                </tr>
                <tr>
                    <th>Fitment Score</th>
                    <td>
                        <?php 
                        if(isset($call_analysis['custom_analysis_data']['_screening _result'])) {
                            // Check if the fitment score is available
                            echo str_replace('Fitment score -', '', $call_analysis['custom_analysis_data']['_screening _result']);
                        } else {
                            echo 'N/A'; // If the key does not exist, display N/A

                        }
                        //echo str_replace('Fitment score -', '', $call_analysis['custom_analysis_data']['_screening _result']); ?>
                    </td>
                </tr>
                <tr>
                    <th>Communication Score</th>
                    <td>
                        <?php 
                        if(isset($call_analysis['custom_analysis_data']['_candidate communication'])) {
                            echo str_replace('Communication score-', '', $call_analysis['custom_analysis_data']['_candidate communication']);
                        } else if(isset($call_analysis['custom_analysis_data']['_communication _analysis'])) {
                            echo str_replace('Communication score-', '', $call_analysis['custom_analysis_data']['_communication _analysis']);
                        }else{
                            echo 'N/A';
                        }
                        ?>
                    </td>
                </tr>
                 <tr>
                    <th>User Sentiment</th>
                    <td><?php echo $call_analysis['user_sentiment'] ?></td>
                </tr>
                <tr>
                    <th>Call Summary</th>
                    <td><?php echo $call_analysis['call_summary'] ?></td>
                </tr>
                <tr>
                    <th>Transcripts</th>
                    <td><textarea rows="15" style="width:100%; font-size: 1rem; padding: 10px; border-radius: 6px; border: 1px solid #ccc; resize: vertical;"><?php echo $transcript; ?></textarea></td>
                </tr>
                
            </tbody>
        </table>
    </div>

    <script>
        function printSection(divId) {
            const content = document.getElementById(divId).innerHTML;
            const printWindow = window.open('', '', 'height=700,width=900');
            printWindow.document.write('<html><head><title>Print</title>');
            printWindow.document.write('<style>body{font-family:sans-serif} table{width:100%;border-collapse:collapse;} th,td{padding:10px;border:1px solid #ccc;} th{background:#f1f5f9;}</style>');
            printWindow.document.write('</head><body>');
            printWindow.document.write(content);
            printWindow.document.write('</body></html>');
            printWindow.document.close();
            printWindow.focus();
            printWindow.print();
            printWindow.close();
        }
    </script>
    <style>
.center-container {
    width: 90%;
    max-width: 800px;
    margin: 0 auto;
}

.status-message.active {
    display: flex;
    align-items: center;
    animation: fadeIn 0.7s;
}

.status-message img {
    width: 50px;
    height: 50px;
    margin-right: 20px;
    border-radius: 50%;
}

.status-message p {
    font-size: 1.15rem;
    color: #222e3a;
    margin: 0;
    line-height: 1.7;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(30px);}
    to { opacity: 1; transform: translateY(0);}
}

table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 20px;
    background-color: #fff;
    border-radius: 12px;
    overflow: hidden;
    box-shadow: 0 2px 12px rgba(0,0,0,0.05);
}

th, td {
    padding: 12px 16px;
    text-align: left;
    border-bottom: 1px solid #f0f0f0;
}

th {
    background-color: #e2e8f0;
    font-weight: bold;
    color: #334155;
    width: 40%;
}

/* Print Button Style */
.print-button {
    margin: 20px 0;
    padding: 10px 20px;
    background-color: #4f8cff;
    color: white;
    border: none;
    border-radius: 6px;
    cursor: pointer;
    font-size: 16px;
}

/* Hide print button during print */
@media print {
    .print-button {
        display: none;
    }

    body {
        background: white !important;
    }
}

    </style>