//import { RetellWebClient } from 'retell-client-js-sdk';
//import { RetellWebClient } from 'retell/dist/index.umd.js';
//const sdk = new RetellClient.RetellWebClient(); // ✅ Not just RetellWebClient

//let sdk;
let callId = '';
let spokenText = new Set();

async function questionsAndAnswers() {
    //console.log(`${BASE_URL}api/onlyAIInterview/${commonId}`);
    const resp = await fetch(`${BASE_URL}api/onlyAIInterview/${commonId}`);
    const data = await resp.json();

    if (!data.access_token) {
        alert("Missing access token. Check backend.");
        return;
    }

    callId = data.call_id;
    const sdk = new RetellClient.RetellWebClient(); // ✅ Not just RetellWebClient

    sdk.on("conversationStarted", () => console.log("🎙️ conversation started"));
    sdk.on("update", (update) => {
        const transcriptDiv = document.getElementById("conversations");
        transcriptDiv.scrollTop = transcriptDiv.scrollHeight;
        update.transcript.forEach((line, i) => {
            console.log(line);
            const key = `${line.role}_${i}`;
            if (!spokenText.has(key)) {
                transcriptDiv.innerHTML += `<p><strong>${line.role}:</strong> ${line.content}</p>`;
                spokenText.add(key);
            }
        });
    });
    sdk.on("error", err => console.error("SDK error:", err));

    await sdk.startCall({
        accessToken: data.access_token,
        enableUpdate: true
    });

    // navigator.mediaDevices.getUserMedia({ video: true })
    //     .then(stream => document.getElementById("userVideo").srcObject = stream)
    //     .catch(err => console.error("Camera error:", err));
}

//window.questionsAndAnswers = questionsAndAnswers;
