(function () {
    function isMobileDeviceByScreen() {
        return window.innerWidth <= 768 || typeof window.orientation !== 'undefined';
    }
    const isMobile = isMobileDeviceByScreen();

    function injectMobileUI() {
        if (!isMobile) return;
        const container = document.getElementById('app-container');
        if (!container || document.querySelector('.mobile-interview-container')) return;

        container.insertAdjacentHTML('afterbegin', `
      <div class="mobile-interview-container">
        <div class="mobile-interview-header">
          <div id="app-header-lhs">
            <img src="${typeof BASE_URL !== 'undefined' ? BASE_URL : ''}assets/images/intrvuz_logo.png" 
                 id="intrvuz" loading="lazy" alt="intrvuz-logo" />
          </div>
        </div>
        <div class="mobile-video-container">
          <video id="mobileUserVideo" autoplay muted playsinline></video>
          <div class="mobile-mira-overlay" id="mobileMiraOverlay">
            <div class="mira-overlay-box">
              <img src="${typeof BASE_URL !== 'undefined' ? BASE_URL : ''}assets/images/mira.png" 
                   alt="Mira Avatar" class="mira-overlay-img" />
              <div class="mira-overlay-status">Mira Speaking...</div>
            </div>
          </div>
          <div class="mobile-chat-overlay" id="mobileChatOverlay">
            <div class="mobile-chat-messages" id="mobileChatMessages"></div>
          </div>
          <div class="mobile-timer-display" id="mobileTimerDisplay">02:00</div>
          <div class="mobile-status-indicators">
            <div class="mobile-status-indicator"><i class="uil uil-volume-up"></i></div>
            <div class="mobile-status-indicator"><i class="uil uil-microphone"></i></div>
            <div class="mobile-status-indicator"><i class="uil uil-video"></i></div>
          </div>
        </div>
        <div class="mobile-interview-controls">
          <button id="mobileTranscriptBtn" class="mobile-control-btn mobile-transcript-btn">
            <i class="uil uil-clipboard"></i>
          </button>
          <button id="mobileMicBtn" class="mobile-control-btn mobile-mic-btn" disabled>
            <i class="uil uil-microphone"></i>
          </button>
          <button id="mobileEndBtn" class="mobile-control-btn mobile-end-btn">
            <i class="uil uil-phone"></i>
          </button>
        </div>
      </div>
    `);
    }

    function setupMobileControls() {
        const tBtn = document.getElementById('mobileTranscriptBtn');
        const chat = document.getElementById('mobileChatOverlay');
        const mBtn = document.getElementById('mobileMicBtn');
        const eBtn = document.getElementById('mobileEndBtn');

        tBtn?.addEventListener('click', () => {
            const active = chat.classList.toggle('active');
            tBtn.classList.toggle('active', active);
        });
        mBtn?.addEventListener('click', () => {
            document.getElementById('micButton')?.click();
        });
        eBtn?.addEventListener('click', () => {
            document.getElementById('end-interview-button')?.click();
        });
    }

    function syncVideoStream() {
        const deskVid = document.getElementById('userVideo');
        const mobileVid = document.getElementById('mobileUserVideo');
        if (deskVid?.srcObject && mobileVid && mobileVid.srcObject !== deskVid.srcObject) {
            mobileVid.srcObject = deskVid.srcObject;
        }
    }

    // Public API for Mira overlay and transcript
    window.mobileInterview = {
        setMiraSpeaking(active) {
            document.getElementById('mobileMiraOverlay')?.classList.toggle('active', !!active);
        },
        renderTranscript(data) {
            const chatContainer = document.getElementById('mobileChatMessages');
            if (!chatContainer) return;
            chatContainer.innerHTML = '';
            data.forEach(entry => {
                const bot = document.createElement('div');
                bot.className = 'mobile-chat-message bot';
                bot.textContent = entry.bot;
                chatContainer.appendChild(bot);
                if (entry.user && entry.user !== "...") {
                    const usr = document.createElement('div');
                    usr.className = 'mobile-chat-message user';
                    usr.textContent = entry.user;
                    chatContainer.appendChild(usr);
                }
            });
            chatContainer.scrollTop = chatContainer.scrollHeight;
        }
    };

    document.addEventListener('DOMContentLoaded', () => {
        if (!isMobile) return;
        injectMobileUI();
        setupMobileControls();
        setInterval(syncVideoStream, 500);
    });

})();
