console.log("Proctor script loaded");

const video = document.getElementById('userVideo');
const proctorCanvas = document.getElementById('proctorCanvas');
let keystrokeCount = 0;
let focusLostCount = 0;
let suspiciousKeysThisInterval = new Set();
const context = proctorCanvas.getContext('2d');
proctorCanvas.width = 480;
proctorCanvas.height = 360;

// const ctx = proctorCanvas.getContext('2d');
// const API_ENDPOINT = 'http://127.0.0.1:5000/analyze';
window.addEventListener('load', () => {
    window.focus();
    document.body.setAttribute('tabindex', '0');
    document.body.focus();
});


// --- Task 1: Handle tab change (focus loss) ---
// Handle tab change or window blur (Alt+Tab, switching tabs, etc.)
window.addEventListener('blur', () => {
    console.warn("FLAG: Window lost focus (Alt+Tab or tab switch)");
    focusLostCount++;
});
document.addEventListener('visibilitychange', () => {
    if (document.hidden) {
        console.warn('FLAG: Document hidden (possibly tab switch or minimize).');
        focusLostCount++;
    }
});

// --- Task 2: Clipboard Paste ---
document.addEventListener('paste', () => {
    suspiciousKeysThisInterval.add('paste-event');
    console.warn("📋 Paste event detected.");
});

// --- Task 3: Keystroke Monitoring ---
document.addEventListener('keydown', (e) => {
    keystrokeCount++;

    const isCtrl = e.ctrlKey || e.metaKey;
    const isAlt = e.altKey;
    const keyCode = e.code.toLowerCase();

    console.log(`Keydown detected: code=${e.code}, key=${e.key}, ctrl=${e.ctrlKey}, alt=${e.altKey}, meta=${e.metaKey}`);

    if (isCtrl && keyCode === 'keyc') suspiciousKeysThisInterval.add('ctrl+c');
    if (isCtrl && keyCode === 'keyv') suspiciousKeysThisInterval.add('ctrl+v');
    if (isCtrl && keyCode === 'keyx') suspiciousKeysThisInterval.add('ctrl+x');
    if (isCtrl && keyCode === 'keya') suspiciousKeysThisInterval.add('ctrl+a');

    // While you can't detect Alt+Tab directly, you *can* count blur events instead.
});

// --- Task 4: Context Menu Blocking ---

document.addEventListener('contextmenu', (e) => {
    e.preventDefault();
    console.warn("Right-click detected and blocked.");
});


async function startProctoring() {
    console.log("Starting proctoring...");

    setInterval(async () => {
        context.drawImage(video, 0, 0, proctorCanvas.width, proctorCanvas.height);
        const imageBase64 = proctorCanvas.toDataURL('image/jpeg').split(',')[1];
        //console.log("<<Keys",suspiciousKeysThisInterval);
        //console.log("<<Focus",focusLostCount);
        const requestData = {
            image: imageBase64,
            keystrokeCount: keystrokeCount,
            focusLostCount: focusLostCount,
            keystrokeMap: Array.from(suspiciousKeysThisInterval)
        };
        try {
            const response = await fetch(`${BASE_URL}/analyze/proctor`, {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(requestData)
            });

            if (!response.ok) {
                console.error("API Error:", response.statusText);
                return;
            }

            const data = await response.json();
            console.log("API Response:", data);

        } catch (error) {
            console.error("Failed to call analysis API:", error);
        }

        keystrokeCount = 0;
        focusLostCount = 0;
        suspiciousKeysThisInterval.clear();
    }, 5000); // 15 seconds interval
}
window.startProctoring = startProctoring;
