// ==================== Monitor Screen Share(warn If Ends) Functions ====================
function monitorScreenSharing(stream) {
    const [screenTrack] = stream.getVideoTracks();
    screenTrack.onended = () => {
        alert("⚠️ You stopped screen sharing. This may disqualify your interview.");
        // Optionally:
        // document.mediaRecorder.stop();
        // window.location.reload();
    };
}
// ======================================================================

// ================== Audio Merging Functions ===========================

// Get user media streams (camera + mic) // please dont delete.
async function getUserMediaStreams() {
    return await navigator.mediaDevices.getUserMedia({ video: true, audio: true });
}

// Merge mic and screen audio tracks
// This function merges the audio from mic and screen streams into a single audio track

function mergeMicScreenStreams(micStream, screenStream) {
    const audioCtx = new AudioContext();
    const dest = audioCtx.createMediaStreamDestination();

    const micSource = audioCtx.createMediaStreamSource(micStream);
    const screenSource = audioCtx.createMediaStreamSource(screenStream);

    micSource.connect(dest);
    screenSource.connect(dest);

    return dest.stream.getAudioTracks()[0];
}

// Create a combined stream with video from screen and audio from mic
function createCombinedStream(videoTrack, audioTrack) {
    const combined = new MediaStream();
    combined.addTrack(videoTrack);
    combined.addTrack(audioTrack);
    return combined;
}

// ======================================================================


// ================== Video Recording Functions ===========================
// Create a MediaRecorder for the video saving and combined Stream
function createMediaRecorder(stream) {
    const recorder = new MediaRecorder(stream, { mimeType: 'video/webm' });
    //this records data
    recorder.ondataavailable = (e) => {
        if (e.data.size > 0) {
            console.log(`Recorded chunk of size: ${e.data.size} bytes`);
            const formData = new FormData();
            formData.append('video_chunk', e.data);
            formData.append('filename', `${commonId}.webm`);

            fetch(`${BASE_URL}api/appendInterviewChunk`, {
                method: 'POST',
                body: formData
            })
                .then(res => res.json())
                .then(data => {
                    if (data.status === 'success') {
                        videoChunks.push(e.data); // ✅ Save only if upload succeeded
                        console.log('✅Video Chunk uploaded and added:', data);
                    } else {
                        console.warn('⚠️ Server rejected chunk:', data.message);
                    }
                })
                .catch(err => {
                    console.warn('❌ Upload failed. Skipping this chunk.', err);
                    // Do NOT push to videoChunks if upload failed
                });
        }
    };

    //stops every 10 seconds and uploads video to server
    recorder.onstop = () => {
        console.log("Recording stopped.");
        // finalVideoBlob = new Blob(videoChunks, { type: 'video/webm' });

        // const formData = new FormData();
        // formData.append('interview_video', finalVideoBlob);
        // formData.append('filename', `${commonId}.webm`);

        // fetch(`${BASE_URL}/api/saveInterviewVideo`, {
        //     method: 'POST',
        //     body: formData
        // })
        // .then(res => res.json())
        // .then(data => {
        //     console.log("✅ Video saved to server:", data);
        // })
        // .catch(err => {
        //     console.error("❌ Video upload failed:", err);
        // });
    };
    return recorder;
}
// ======================================================================

